/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.config;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.spring.data.cosmos.CosmosFactory;
import com.azure.spring.data.cosmos.config.CosmosConfig;
import com.azure.spring.data.cosmos.config.CosmosConfigurationSupport;
import com.azure.spring.data.cosmos.core.CosmosTemplate;
import com.azure.spring.data.cosmos.core.ReactiveCosmosTemplate;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.mapping.CosmosMappingContext;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentEntity;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mapping.context.MappingContext;

@Configuration
public abstract class AbstractCosmosConfiguration
extends CosmosConfigurationSupport {
    @Qualifier(value="cosmosObjectMapper")
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    @Qualifier(value="cosmosAuditingHandler")
    @Autowired(required=false)
    private IsNewAwareAuditingHandler cosmosAuditingHandler;

    @Bean
    public CosmosFactory cosmosFactory(CosmosAsyncClient cosmosAsyncClient) {
        return new CosmosFactory(cosmosAsyncClient, this.getDatabaseName());
    }

    @Bean
    public MappingCosmosConverter mappingCosmosConverter(CosmosMappingContext cosmosMappingContext) {
        return new MappingCosmosConverter((MappingContext<? extends CosmosPersistentEntity<?>, CosmosPersistentProperty>)cosmosMappingContext, this.objectMapper);
    }

    @Bean
    public CosmosAsyncClient cosmosAsyncClient(CosmosClientBuilder cosmosClientBuilder) {
        return CosmosFactory.createCosmosAsyncClient(cosmosClientBuilder);
    }

    @Bean
    public CosmosTemplate cosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        return new CosmosTemplate(cosmosFactory, cosmosConfig, mappingCosmosConverter, this.cosmosAuditingHandler);
    }

    @Bean
    public ReactiveCosmosTemplate reactiveCosmosTemplate(CosmosFactory cosmosFactory, CosmosConfig cosmosConfig, MappingCosmosConverter mappingCosmosConverter) {
        return new ReactiveCosmosTemplate(cosmosFactory, cosmosConfig, mappingCosmosConverter, this.cosmosAuditingHandler);
    }

    @Bean
    public CosmosConfig cosmosConfig() {
        return new CosmosConfig.CosmosConfigBuilder().build();
    }
}

