/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core;

import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.convert.MappingCosmosConverter;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;

public interface CosmosOperations {
    public String getContainerName(Class<?> var1);

    public CosmosContainerProperties createContainerIfNotExists(CosmosEntityInformation<?, ?> var1);

    public CosmosContainerProperties getContainerProperties(String var1);

    public CosmosContainerProperties replaceContainerProperties(String var1, CosmosContainerProperties var2);

    public <T> Iterable<T> findAll(Class<T> var1);

    public <T> Iterable<T> findAll(String var1, Class<T> var2);

    public <T> Iterable<T> findAll(PartitionKey var1, Class<T> var2);

    public <T> T findById(Object var1, Class<T> var2);

    public <T> T findById(String var1, Object var2, Class<T> var3);

    public <T> T findById(Object var1, Class<T> var2, PartitionKey var3);

    public <T> T insert(T var1, PartitionKey var2);

    public <T> T patch(Object var1, PartitionKey var2, Class<T> var3, CosmosPatchOperations var4);

    public <T> T patch(Object var1, PartitionKey var2, Class<T> var3, CosmosPatchOperations var4, CosmosPatchItemRequestOptions var5);

    public <T> T insert(String var1, T var2, PartitionKey var3);

    public <S extends T, T> Iterable<S> insertAll(CosmosEntityInformation<T, ?> var1, Iterable<S> var2);

    public <T> T insert(String var1, T var2);

    public <T> void upsert(T var1);

    public <T> void upsert(String var1, T var2);

    public <T> T upsertAndReturnEntity(String var1, T var2);

    public void deleteById(String var1, Object var2, PartitionKey var3);

    public <T> void deleteEntity(String var1, T var2);

    public <S extends T, T> void deleteEntities(CosmosEntityInformation<T, ?> var1, Iterable<S> var2);

    public void deleteAll(String var1, Class<?> var2);

    public void deleteContainer(String var1);

    public <T> Iterable<T> delete(CosmosQuery var1, Class<T> var2, String var3);

    public <T> Iterable<T> find(CosmosQuery var1, Class<T> var2, String var3);

    public <T, ID> Iterable<T> findByIds(Iterable<ID> var1, Class<T> var2, String var3);

    public <T> Boolean exists(CosmosQuery var1, Class<T> var2, String var3);

    public <T> Page<T> findAll(Pageable var1, Class<T> var2, String var3);

    public <T> Page<T> paginationQuery(CosmosQuery var1, Class<T> var2, String var3);

    public <T> Slice<T> sliceQuery(CosmosQuery var1, Class<T> var2, String var3);

    public <T> Slice<T> runSliceQuery(SqlQuerySpec var1, Pageable var2, Class<?> var3, Class<T> var4);

    public long count(String var1);

    public <T> long count(CosmosQuery var1, String var2);

    public <T> long count(SqlQuerySpec var1, String var2);

    public MappingCosmosConverter getConverter();

    public <T> Iterable<T> runQuery(SqlQuerySpec var1, Class<?> var2, Class<T> var3);

    public <T> Iterable<T> runQuery(SqlQuerySpec var1, Sort var2, Class<?> var3, Class<T> var4);

    public <T> Page<T> runPaginationQuery(SqlQuerySpec var1, Pageable var2, Class<?> var3, Class<T> var4);
}

