/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.cosmos.models.CompositePath;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingMode;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.UniqueKey;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.azure.spring.data.cosmos.Constants;
import com.azure.spring.data.cosmos.common.ExpressionResolver;
import com.azure.spring.data.cosmos.common.Memoizer;
import com.azure.spring.data.cosmos.core.mapping.CompositeIndex;
import com.azure.spring.data.cosmos.core.mapping.CompositeIndexPath;
import com.azure.spring.data.cosmos.core.mapping.Container;
import com.azure.spring.data.cosmos.core.mapping.CosmosIndexingPolicy;
import com.azure.spring.data.cosmos.core.mapping.CosmosUniqueKey;
import com.azure.spring.data.cosmos.core.mapping.CosmosUniqueKeyPolicy;
import com.azure.spring.data.cosmos.core.mapping.GeneratedValue;
import com.azure.spring.data.cosmos.core.mapping.PartitionKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class CosmosEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private static final Function<Class<?>, CosmosEntityInformation<?, ?>> ENTITY_INFORMATION_CREATOR = Memoizer.memoize(CosmosEntityInformation::getCosmosEntityInformation);
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosEntityInformation.class);
    private final Field id;
    private final Field partitionKeyField;
    private final Field versionField;
    private final List<String> transientFields;
    private final String containerName;
    private final String partitionKeyPath;
    private final String[] hierarchicalPartitionKeyPaths;
    private final Integer requestUnit;
    private final Integer timeToLive;
    private final IndexingPolicy indexingPolicy;
    private final UniqueKeyPolicy uniqueKeyPolicy;
    private final boolean autoCreateContainer;
    private final boolean autoGenerateId;
    private final boolean persitable;
    private final boolean autoScale;
    private final boolean isIndexingPolicySpecified;
    private final boolean overwriteIndexingPolicy;

    private static CosmosEntityInformation<?, ?> getCosmosEntityInformation(Class<?> domainClass) {
        return new CosmosEntityInformation(domainClass);
    }

    public static CosmosEntityInformation<?, ?> getInstance(Class<?> domainClass) {
        return ENTITY_INFORMATION_CREATOR.apply(domainClass);
    }

    public CosmosEntityInformation(Class<T> domainType) {
        super(domainType);
        this.id = CosmosEntityInformationHelper.getIdField(domainType, this.getJavaType());
        ReflectionUtils.makeAccessible((Field)this.id);
        this.autoGenerateId = CosmosEntityInformationHelper.isIdFieldAnnotatedWithGeneratedValue(this.id);
        this.containerName = CosmosEntityInformationHelper.getContainerName(domainType);
        this.partitionKeyPath = CosmosEntityInformationHelper.getPartitionKeyPathAnnotationValue(domainType);
        this.hierarchicalPartitionKeyPaths = CosmosEntityInformationHelper.getHierarchicalPartitionKeyPathsAnnotationValue(domainType);
        this.partitionKeyField = CosmosEntityInformationHelper.getPartitionKeyField(domainType);
        this.transientFields = CosmosEntityInformationHelper.getTransientFields(domainType);
        if (this.partitionKeyField != null) {
            ReflectionUtils.makeAccessible((Field)this.partitionKeyField);
        }
        this.versionField = CosmosEntityInformationHelper.getVersionedField(domainType);
        if (this.versionField != null) {
            ReflectionUtils.makeAccessible((Field)this.versionField);
        }
        this.requestUnit = CosmosEntityInformationHelper.getRequestUnit(domainType);
        this.timeToLive = CosmosEntityInformationHelper.getTimeToLive(domainType);
        this.indexingPolicy = CosmosEntityInformationHelper.getIndexingPolicy(domainType);
        this.uniqueKeyPolicy = CosmosEntityInformationHelper.getUniqueKeyPolicy(domainType);
        this.autoCreateContainer = CosmosEntityInformationHelper.getIsAutoCreateContainer(domainType);
        this.persitable = Persistable.class.isAssignableFrom(domainType);
        this.autoScale = CosmosEntityInformationHelper.getIsAutoScale(domainType);
        this.isIndexingPolicySpecified = CosmosEntityInformationHelper.isIndexingPolicySpecified(domainType);
        this.overwriteIndexingPolicy = CosmosEntityInformationHelper.getIndexingPolicyOverwritePolicy(domainType);
    }

    public boolean isNew(T entity) {
        if (this.persitable) {
            return ((Persistable)entity).isNew();
        }
        return super.isNew(entity);
    }

    public ID getId(T entity) {
        return (ID)ReflectionUtils.getField((Field)this.id, entity);
    }

    public Field getIdField() {
        return this.id;
    }

    public List<String> getTransientFields() {
        return this.transientFields;
    }

    public String getIdFieldName() {
        return this.id.getName();
    }

    public boolean shouldGenerateId() {
        return this.autoGenerateId;
    }

    public Class<ID> getIdType() {
        return this.id.getType();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public Integer getRequestUnit() {
        return this.requestUnit;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @NonNull
    public IndexingPolicy getIndexingPolicy() {
        return this.indexingPolicy;
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    public boolean isVersioned() {
        return this.versionField != null;
    }

    public String getVersionFieldName() {
        return this.versionField == null ? null : this.versionField.getName();
    }

    public String getPartitionKeyPath() {
        if (this.partitionKeyField != null) {
            PartitionKey partitionKey = this.partitionKeyField.getAnnotation(PartitionKey.class);
            return partitionKey.value().equals("") ? "/" + this.partitionKeyField.getName() : "/" + partitionKey.value();
        }
        if (this.partitionKeyPath != null) {
            return this.partitionKeyPath;
        }
        if (this.hierarchicalPartitionKeyPaths != null && this.hierarchicalPartitionKeyPaths.length > 0) {
            String hierarchicalPartitionKeyPath = "";
            for (String path : this.hierarchicalPartitionKeyPaths) {
                hierarchicalPartitionKeyPath = hierarchicalPartitionKeyPath == "" ? path : hierarchicalPartitionKeyPath + ", " + path;
            }
            return hierarchicalPartitionKeyPath;
        }
        return "/null";
    }

    public String getVersionFieldValue(Object entity) {
        return this.versionField == null ? null : (String)ReflectionUtils.getField((Field)this.versionField, (Object)entity);
    }

    public Object getPartitionKeyFieldValue(T entity) {
        if (this.partitionKeyField != null) {
            return ReflectionUtils.getField((Field)this.partitionKeyField, entity);
        }
        if (this.partitionKeyPath != null) {
            List<String> parts = Arrays.stream(this.partitionKeyPath.split("/")).collect(Collectors.toList());
            Object[] currentObject = new Object[]{entity};
            parts.forEach(part -> {
                if (!part.isEmpty()) {
                    Field f = null;
                    try {
                        f = currentObject[0].getClass().getDeclaredField((String)part);
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    ReflectionUtils.makeAccessible((Field)f);
                    currentObject[0] = ReflectionUtils.getField((Field)f, (Object)currentObject[0]);
                }
            });
            return currentObject[0];
        }
        if (this.hierarchicalPartitionKeyPaths != null && this.hierarchicalPartitionKeyPaths.length > 0) {
            ArrayList<Object> pkValues = new ArrayList<Object>();
            for (String path : this.hierarchicalPartitionKeyPaths) {
                Field f = null;
                try {
                    f = entity.getClass().getDeclaredField(path.substring(1));
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                ReflectionUtils.makeAccessible((Field)f);
                pkValues.add(ReflectionUtils.getField((Field)f, entity));
            }
            return pkValues;
        }
        return null;
    }

    public String getPartitionKeyFieldName() {
        if (this.partitionKeyField != null) {
            return this.partitionKeyField.getName();
        }
        if (this.partitionKeyPath != null) {
            return this.partitionKeyPath.substring(1).replace("/", ".");
        }
        if (this.hierarchicalPartitionKeyPaths != null && this.hierarchicalPartitionKeyPaths.length > 0) {
            String hierarchicalPartitionKeyFiledName = "";
            for (String path : this.hierarchicalPartitionKeyPaths) {
                hierarchicalPartitionKeyFiledName = hierarchicalPartitionKeyFiledName == "" ? path.substring(1) : hierarchicalPartitionKeyFiledName + ", " + path.substring(1);
            }
            return hierarchicalPartitionKeyFiledName;
        }
        return null;
    }

    public boolean isAutoCreateContainer() {
        return this.autoCreateContainer;
    }

    public boolean isOverwriteIndexingPolicy() {
        return this.overwriteIndexingPolicy;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public boolean isIndexingPolicySpecified() {
        return this.isIndexingPolicySpecified;
    }

    static class CosmosEntityInformationHelper {
        CosmosEntityInformationHelper() {
        }

        private static boolean isIndexingPolicySpecified(Class<?> domainType) {
            return domainType.getAnnotation(CosmosIndexingPolicy.class) != null;
        }

        private static IndexingPolicy getIndexingPolicy(Class<?> domainType) {
            IndexingPolicy policy = new IndexingPolicy();
            policy.setAutomatic(CosmosEntityInformationHelper.getIndexingPolicyAutomatic(domainType));
            policy.setIndexingMode(CosmosEntityInformationHelper.getIndexingPolicyMode(domainType));
            policy.setIncludedPaths(CosmosEntityInformationHelper.getIndexingPolicyIncludePaths(domainType));
            policy.setExcludedPaths(CosmosEntityInformationHelper.getIndexingPolicyExcludePaths(domainType));
            policy.setCompositeIndexes(CosmosEntityInformationHelper.getIndexingPolicyCompositeIndexes(domainType));
            return policy;
        }

        private static UniqueKeyPolicy getUniqueKeyPolicy(Class<?> domainType) {
            CosmosUniqueKeyPolicy annotation = domainType.getAnnotation(CosmosUniqueKeyPolicy.class);
            if (annotation == null) {
                return null;
            }
            List<UniqueKey> uniqueKeys = CosmosEntityInformationHelper.getUniqueKeys(domainType);
            if (uniqueKeys.isEmpty()) {
                return null;
            }
            return new UniqueKeyPolicy().setUniqueKeys(uniqueKeys);
        }

        private static Field getIdField(Class<?> domainType, Class<?> javaType) {
            Field idField;
            List fields = FieldUtils.getFieldsListWithAnnotation(domainType, Id.class);
            if (fields.isEmpty()) {
                idField = ReflectionUtils.findField(javaType, (String)"id");
            } else if (fields.size() == 1) {
                idField = (Field)fields.get(0);
            } else {
                throw new IllegalArgumentException("only one field with @Id annotation!");
            }
            if (idField == null) {
                throw new IllegalArgumentException("domain should contain @Id field or field named id");
            }
            if (idField.getType() != String.class && idField.getType() != Integer.class && idField.getType() != Integer.TYPE && idField.getType() != Long.class && idField.getType() != Long.TYPE && idField.getType() != UUID.class) {
                throw new IllegalArgumentException("type of id field must be String, Integer, Long or UUID");
            }
            return idField;
        }

        private static boolean isIdFieldAnnotatedWithGeneratedValue(Field idField) {
            if (idField.getAnnotation(GeneratedValue.class) != null) {
                if (idField.getType() == String.class) {
                    return true;
                }
                throw new IllegalArgumentException("id field must be of type String if GeneratedValue annotation is present");
            }
            return false;
        }

        private static String getContainerName(Class<?> domainType) {
            String customContainerName = domainType.getSimpleName();
            Container annotation = domainType.getAnnotation(Container.class);
            if (annotation != null && !annotation.containerName().isEmpty()) {
                customContainerName = ExpressionResolver.resolveExpression(annotation.containerName());
            }
            return customContainerName;
        }

        private static String getPartitionKeyPathAnnotationValue(Class<?> domainType) {
            Container annotation = domainType.getAnnotation(Container.class);
            if (annotation != null && !annotation.partitionKeyPath().isEmpty()) {
                return annotation.partitionKeyPath();
            }
            return null;
        }

        private static String[] getHierarchicalPartitionKeyPathsAnnotationValue(Class<?> domainType) {
            Container annotation = domainType.getAnnotation(Container.class);
            if (annotation != null && annotation.hierarchicalPartitionKeyPaths().length > 0) {
                return annotation.hierarchicalPartitionKeyPaths();
            }
            return null;
        }

        private static Field getPartitionKeyField(Class<?> domainType) {
            Field partitionKey = null;
            List fields = FieldUtils.getFieldsListWithAnnotation(domainType, PartitionKey.class);
            if (fields.size() == 1) {
                partitionKey = (Field)fields.get(0);
            } else if (fields.size() > 1) {
                throw new IllegalArgumentException("Azure Cosmos DB supports only one partition key, only one field with @PartitionKey annotation!");
            }
            return partitionKey;
        }

        private static List<String> getTransientFields(Class<?> domainType) {
            Field partitionKeyField = CosmosEntityInformationHelper.getPartitionKeyField(domainType);
            List fields = FieldUtils.getFieldsListWithAnnotation(domainType, Transient.class);
            ArrayList<String> transientFieldNames = new ArrayList<String>();
            for (Field field : fields) {
                if (field.equals(partitionKeyField) || field.getName().equalsIgnoreCase("id") || field.getName().equalsIgnoreCase("_etag")) {
                    throw new IllegalArgumentException("Field cannot be declared transient: " + field.getName());
                }
                LOGGER.warn("Transient field will not be persisted: {}", (Object)field);
                transientFieldNames.add(field.getName());
            }
            return transientFieldNames;
        }

        private static Integer getRequestUnit(Class<?> domainType) {
            Integer ru = null;
            Container annotation = domainType.getAnnotation(Container.class);
            if (annotation != null && annotation.ru() != null && !annotation.ru().isEmpty()) {
                ru = Integer.parseInt(annotation.ru());
            }
            return ru;
        }

        private static Integer getTimeToLive(Class<?> domainType) {
            Integer ttl = -1;
            Container annotation = domainType.getAnnotation(Container.class);
            if (annotation != null) {
                ttl = annotation.timeToLive();
            }
            return ttl;
        }

        private static boolean getIndexingPolicyOverwritePolicy(Class<?> domainType) {
            boolean isOverwritePolicy = false;
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation != null) {
                isOverwritePolicy = annotation.overwritePolicy();
            }
            return isOverwritePolicy;
        }

        private static boolean getIndexingPolicyAutomatic(Class<?> domainType) {
            boolean isAutomatic = true;
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation != null) {
                isAutomatic = annotation.automatic();
            }
            return isAutomatic;
        }

        private static IndexingMode getIndexingPolicyMode(Class<?> domainType) {
            IndexingMode mode = Constants.DEFAULT_INDEXING_POLICY_MODE;
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation != null) {
                mode = annotation.mode();
            }
            return mode;
        }

        private static List<IncludedPath> getIndexingPolicyIncludePaths(Class<?> domainType) {
            String[] rawPaths;
            ArrayList<IncludedPath> pathArrayList = new ArrayList<IncludedPath>();
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation == null || annotation.includePaths().length == 0) {
                return null;
            }
            for (String path : rawPaths = annotation.includePaths()) {
                pathArrayList.add(new IncludedPath(path));
            }
            return pathArrayList;
        }

        private static List<ExcludedPath> getIndexingPolicyExcludePaths(Class<?> domainType) {
            String[] rawPaths;
            ArrayList<ExcludedPath> pathArrayList = new ArrayList<ExcludedPath>();
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation == null || annotation.excludePaths().length == 0) {
                return null;
            }
            for (String path : rawPaths = annotation.excludePaths()) {
                pathArrayList.add(new ExcludedPath(path));
            }
            return pathArrayList;
        }

        private static List<List<CompositePath>> getIndexingPolicyCompositeIndexes(Class<?> domainType) {
            CompositeIndex[] compositeIndexes;
            ArrayList<List<CompositePath>> compositePathList = new ArrayList<List<CompositePath>>();
            CosmosIndexingPolicy annotation = domainType.getAnnotation(CosmosIndexingPolicy.class);
            if (annotation == null || annotation.compositeIndexes().length == 0) {
                return Collections.emptyList();
            }
            for (CompositeIndex index : compositeIndexes = annotation.compositeIndexes()) {
                ArrayList<CompositePath> paths = new ArrayList<CompositePath>();
                compositePathList.add(paths);
                for (CompositeIndexPath path : index.paths()) {
                    CompositePath compositePath = new CompositePath();
                    compositePath.setPath(path.path());
                    compositePath.setOrder(path.order());
                    paths.add(compositePath);
                }
            }
            return compositePathList;
        }

        private static List<UniqueKey> getUniqueKeys(Class<?> domainType) {
            CosmosUniqueKeyPolicy annotation = domainType.getAnnotation(CosmosUniqueKeyPolicy.class);
            assert (annotation != null);
            if (annotation.uniqueKeys().length == 0) {
                return Collections.emptyList();
            }
            CosmosUniqueKey[] uniqueKeysPath = annotation.uniqueKeys();
            ArrayList<UniqueKey> uniqueKeys = new ArrayList<UniqueKey>();
            for (CosmosUniqueKey uniqueKey : uniqueKeysPath) {
                UniqueKey key = new UniqueKey(Arrays.asList(uniqueKey.paths()));
                uniqueKeys.add(key);
            }
            return uniqueKeys;
        }

        private static Field getVersionedField(Class<?> domainClass) {
            Field version = null;
            List fields = FieldUtils.getFieldsListWithAnnotation(domainClass, Version.class);
            if (fields.size() == 1) {
                version = (Field)fields.get(0);
            } else if (fields.size() > 1) {
                throw new IllegalArgumentException("Azure Cosmos DB supports only one field with @Version annotation!");
            }
            if (version != null && version.getType() != String.class) {
                throw new IllegalArgumentException("type of Version field must be String");
            }
            return version;
        }

        private static boolean getIsAutoCreateContainer(Class<?> domainType) {
            Container annotation = domainType.getAnnotation(Container.class);
            boolean autoCreateContainer = true;
            if (annotation != null) {
                autoCreateContainer = annotation.autoCreateContainer();
            }
            return autoCreateContainer;
        }

        private static boolean getIsAutoScale(Class<?> domainType) {
            Container annotation = domainType.getAnnotation(Container.class);
            boolean autoScale = false;
            if (annotation != null) {
                autoScale = annotation.autoScale();
            }
            return autoScale;
        }
    }
}

