/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class FilesForceCloseHandlesHeaders {
    @JsonProperty(value="x-ms-marker")
    private String xMsMarker;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-number-of-handles-closed")
    private Integer xMsNumberOfHandlesClosed;
    @JsonProperty(value="x-ms-number-of-handles-failed")
    private Integer xMsNumberOfHandlesFailed;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public FilesForceCloseHandlesHeaders(HttpHeaders rawHeaders) {
        String xMsNumberOfHandlesFailed;
        this.xMsMarker = rawHeaders.getValue("x-ms-marker");
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        String xMsNumberOfHandlesClosed = rawHeaders.getValue("x-ms-number-of-handles-closed");
        if (xMsNumberOfHandlesClosed != null) {
            this.xMsNumberOfHandlesClosed = Integer.parseInt(xMsNumberOfHandlesClosed);
        }
        if ((xMsNumberOfHandlesFailed = rawHeaders.getValue("x-ms-number-of-handles-failed")) != null) {
            this.xMsNumberOfHandlesFailed = Integer.parseInt(xMsNumberOfHandlesFailed);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        String date = rawHeaders.getValue("Date");
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsMarker() {
        return this.xMsMarker;
    }

    public FilesForceCloseHandlesHeaders setXMsMarker(String xMsMarker) {
        this.xMsMarker = xMsMarker;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesForceCloseHandlesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Integer getXMsNumberOfHandlesClosed() {
        return this.xMsNumberOfHandlesClosed;
    }

    public FilesForceCloseHandlesHeaders setXMsNumberOfHandlesClosed(Integer xMsNumberOfHandlesClosed) {
        this.xMsNumberOfHandlesClosed = xMsNumberOfHandlesClosed;
        return this;
    }

    public Integer getXMsNumberOfHandlesFailed() {
        return this.xMsNumberOfHandlesFailed;
    }

    public FilesForceCloseHandlesHeaders setXMsNumberOfHandlesFailed(Integer xMsNumberOfHandlesFailed) {
        this.xMsNumberOfHandlesFailed = xMsNumberOfHandlesFailed;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesForceCloseHandlesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesForceCloseHandlesHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

