/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Base64;

@JacksonXmlRootElement(localName="null")
public final class FilesUploadRangeHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean xMsRequestServerEncrypted;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="x-ms-file-last-write-time")
    private OffsetDateTime xMsFileLastWriteTime;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;

    public FilesUploadRangeHeaders(HttpHeaders rawHeaders) {
        String contentMD5;
        String xMsFileLastWriteTime;
        String date;
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.eTag = rawHeaders.getValue("ETag");
        String lastModified = rawHeaders.getValue("Last-Modified");
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        String xMsRequestServerEncrypted = rawHeaders.getValue("x-ms-request-server-encrypted");
        if (xMsRequestServerEncrypted != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        if ((date = rawHeaders.getValue("Date")) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        if ((xMsFileLastWriteTime = rawHeaders.getValue("x-ms-file-last-write-time")) != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
        if ((contentMD5 = rawHeaders.getValue("Content-MD5")) != null) {
            this.contentMD5 = Base64.getDecoder().decode(contentMD5);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesUploadRangeHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesUploadRangeHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesUploadRangeHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesUploadRangeHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public FilesUploadRangeHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesUploadRangeHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesUploadRangeHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public FilesUploadRangeHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }
}

