/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.web.pullrefresh;

import com.azure.spring.cloud.config.AppConfigurationRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Component
public final class AppConfigurationEventListener
implements ApplicationListener<ServletRequestHandledEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationEventListener.class);
    private final AppConfigurationRefresh appConfigurationRefresh;

    public AppConfigurationEventListener(AppConfigurationRefresh appConfigurationRefresh) {
        this.appConfigurationRefresh = appConfigurationRefresh;
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        try {
            if (!event.getRequestUrl().equals("/actuator/appconfiguration-refresh") && !event.getRequestUrl().equals("/actuator/appconfiguration-refresh-bus")) {
                this.appConfigurationRefresh.refreshConfigurations();
            }
        }
        catch (Exception e) {
            LOGGER.error("Refresh failed with unexpected exception.", (Throwable)e);
        }
    }
}

