/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.net;

import com.barchart.udt.ErrorUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.net.ExceptionSendUDT;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.IllegalBlockingModeException;

public class NetOutputStreamUDT
extends OutputStream {
    protected final SocketUDT socketUDT;

    public NetOutputStreamUDT(SocketUDT socketUDT) {
        if (!socketUDT.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.socketUDT = socketUDT;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.write(bytes);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        int count;
        for (int bytesRemaining = len; bytesRemaining > 0; bytesRemaining -= count) {
            count = this.socketUDT.send(bytes, off + len - bytesRemaining, off + len);
            if (count > 0) {
                continue;
            }
            if (count == 0) {
                throw new ExceptionSendUDT(this.socketUDT.id(), ErrorUDT.USER_DEFINED_MESSAGE, "UDT send time out");
            }
            throw new IllegalStateException("Socket has been chaged to non-blocking");
        }
    }

    @Override
    public void close() throws IOException {
        this.socketUDT.close();
    }
}

