/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.domain.declarative.integration.cdi;

import com.blazebit.domain.declarative.DeclarativeDomain;
import com.blazebit.domain.declarative.DeclarativeDomainConfiguration;
import com.blazebit.domain.declarative.DomainFunctions;
import com.blazebit.domain.declarative.DomainType;
import com.blazebit.domain.declarative.integration.cdi.CustomBean;
import com.blazebit.domain.declarative.integration.cdi.DefaultLiteral;
import com.blazebit.domain.spi.ServiceProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;

public class DeclarativeDomainExtension
implements Extension {
    private final DeclarativeDomainConfiguration configuration = DeclarativeDomain.getDefaultProvider().createDefaultConfiguration();
    private final List<RuntimeException> exceptions = new ArrayList<RuntimeException>();

    <X> void processEntityView(@Observes @WithAnnotations(value={DomainType.class, DomainFunctions.class}) ProcessAnnotatedType<X> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(DomainType.class)) {
            try {
                this.configuration.addDomainType(pat.getAnnotatedType().getJavaClass());
            }
            catch (RuntimeException ex) {
                this.exceptions.add(new IllegalArgumentException("Exception occurred while reading domain type class: " + pat.getAnnotatedType().getJavaClass().getName(), ex));
            }
        }
        if (pat.getAnnotatedType().isAnnotationPresent(DomainFunctions.class)) {
            try {
                this.configuration.addDomainFunctions(pat.getAnnotatedType().getJavaClass());
            }
            catch (RuntimeException ex) {
                this.exceptions.add(new IllegalArgumentException("Exception occurred while reading domain type class: " + pat.getAnnotatedType().getJavaClass().getName(), ex));
            }
        }
    }

    void beforeBuild(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (!this.exceptions.isEmpty()) {
            for (RuntimeException exception : this.exceptions) {
                abd.addDefinitionError((Throwable)exception);
            }
            return;
        }
        Class<DeclarativeDomainConfiguration> beanClass = DeclarativeDomainConfiguration.class;
        Class[] types = new Class[]{DeclarativeDomainConfiguration.class, Object.class};
        Annotation[] qualifiers = new Annotation[]{new DefaultLiteral()};
        Class<Dependent> scope = Dependent.class;
        CustomBean<DeclarativeDomainConfiguration> bean = new CustomBean<DeclarativeDomainConfiguration>(beanClass, types, qualifiers, scope, this.configuration);
        this.configuration.withServiceProvider((ServiceProvider)new BeanManagerServiceProvider(bm));
        abd.addBean(bean);
    }

    private static class BeanManagerServiceProvider
    implements ServiceProvider {
        private final BeanManager beanManager;

        public BeanManagerServiceProvider(BeanManager beanManager) {
            this.beanManager = beanManager;
        }

        public <T> T getService(Class<T> serviceClass) {
            Set beans = this.beanManager.getBeans(serviceClass, new Annotation[0]);
            if (beans.isEmpty()) {
                return null;
            }
            Bean bean = this.beanManager.resolve(beans);
            CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)bean);
            return (T)this.beanManager.getReference(bean, serviceClass, creationalContext);
        }
    }
}

