/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job.transaction.javaee;

import com.blazebit.exception.ExceptionUtils;
import com.blazebit.job.JobContext;
import com.blazebit.job.spi.TransactionSupport;
import com.blazebit.job.transaction.javaee.JtaResources;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class JtaTransactionSupport
implements TransactionSupport {
    private final TransactionManager tm;
    private final TransactionSynchronizationRegistry tsr;

    public JtaTransactionSupport() {
        this(JtaResources.getInstance());
    }

    private JtaTransactionSupport(JtaResources jtaResources) {
        this(jtaResources.getTransactionManager(), jtaResources.getTransactionSynchronizationRegistry());
    }

    public JtaTransactionSupport(TransactionManager tm) {
        this(tm, (TransactionSynchronizationRegistry)tm);
    }

    public JtaTransactionSupport(TransactionManager tm, TransactionSynchronizationRegistry tsr) {
        if (tm == null) {
            throw new IllegalArgumentException("No TransactionManager given!");
        }
        if (tsr == null) {
            throw new IllegalArgumentException("No TransactionSynchronizationRegistry given!");
        }
        this.tm = tm;
        this.tsr = tsr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T transactional(JobContext context, long transactionTimeoutMillis, boolean joinIfPossible, Callable<T> callable, Consumer<Throwable> exceptionHandler) {
        boolean ourTx = false;
        Transaction tx = null;
        Transaction suspendedTx = null;
        Throwable exception = null;
        int status = this.tm.getStatus();
        if (joinIfPossible && this.allOk(status)) {
            tx = this.tm.getTransaction();
        } else {
            ourTx = true;
            this.tm.setTransactionTimeout((int)TimeUnit.MILLISECONDS.toSeconds(transactionTimeoutMillis));
            if (status == 6) {
                this.tm.begin();
                tx = this.tm.getTransaction();
            } else {
                suspendedTx = this.tm.suspend();
                this.tm.begin();
                tx = this.tm.getTransaction();
            }
        }
        T t = callable.call();
        if (!ourTx) return t;
        try {
            if (tx == null) return t;
            switch (tx.getStatus()) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.tm.commit();
                    return t;
                }
                default: {
                    this.tm.rollback();
                    return t;
                }
            }
        }
        catch (Throwable e) {
            if (exception == null) {
                exceptionHandler.accept(e);
                return t;
            } else {
                exception.addSuppressed(e);
            }
            return t;
        }
        finally {
            if (suspendedTx != null) {
                try {
                    this.tm.resume(suspendedTx);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable t2) {
            T t3;
            try {
                exception = t2;
                if (tx != null) {
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (Throwable e) {
                        t2.addSuppressed(e);
                    }
                }
                if (ourTx) {
                    exceptionHandler.accept(t2);
                } else {
                    ExceptionUtils.doThrow((Throwable)t2);
                }
                t3 = null;
                if (!ourTx) return t3;
            }
            catch (Throwable throwable) {
                if (!ourTx) throw throwable;
                try {
                    if (tx == null) throw throwable;
                    switch (tx.getStatus()) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            this.tm.commit();
                            throw throwable;
                        }
                        default: {
                            this.tm.rollback();
                            throw throwable;
                        }
                    }
                }
                catch (Throwable e) {
                    if (exception == null) {
                        exceptionHandler.accept(e);
                        throw throwable;
                    } else {
                        exception.addSuppressed(e);
                    }
                    throw throwable;
                }
                finally {
                    if (suspendedTx != null) {
                        try {
                            this.tm.resume(suspendedTx);
                        }
                        catch (Throwable throwable2) {}
                    }
                }
            }
            try {
                if (tx == null) return t3;
                switch (tx.getStatus()) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.tm.commit();
                        return t3;
                    }
                    default: {
                        this.tm.rollback();
                        return t3;
                    }
                }
            }
            catch (Throwable e) {
                if (exception == null) {
                    exceptionHandler.accept(e);
                    return t3;
                } else {
                    exception.addSuppressed(e);
                }
                return t3;
            }
            finally {
                if (suspendedTx != null) {
                    try {
                        this.tm.resume(suspendedTx);
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    private boolean allOk(int status) {
        switch (status) {
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public void registerPostCommitListener(final Runnable o) {
        try {
            if (this.tm.getStatus() == 6) {
                throw new IllegalStateException("No active transaction!");
            }
            this.tsr.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    if (status == 3) {
                        o.run();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

