/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class CTEBuilderListenerImpl
implements CTEBuilderListener {
    private Set<CTEInfoBuilder> currentCteBuilders = Collections.newSetFromMap(new IdentityHashMap());

    @Override
    public void onReplaceBuilder(CTEInfoBuilder oldBuilder, CTEInfoBuilder newBuilder) {
        if (!this.currentCteBuilders.remove(oldBuilder)) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentCteBuilders.add(newBuilder);
    }

    public void verifyBuilderEnded() {
        if (!this.currentCteBuilders.isEmpty()) {
            throw new BuilderChainingException("Some CTE builders were not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(CTEInfoBuilder builder) {
        if (!this.currentCteBuilders.remove(builder)) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
    }

    @Override
    public void onBuilderStarted(CTEInfoBuilder builder) {
        this.currentCteBuilders.add(builder);
    }
}

