/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.CriteriaBuilderFactoryImpl;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.JpqlMacroAwareExpressionFactory;
import com.blazebit.persistence.impl.JpqlMacroStorage;
import com.blazebit.persistence.impl.ManagedEntityAssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.MutableQueryConfiguration;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.QueryConfiguration;
import com.blazebit.persistence.parser.expression.AbstractCachingExpressionFactory;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlMacro;
import java.util.Map;
import javax.persistence.EntityManager;

public class MainQuery {
    final CriteriaBuilderFactoryImpl cbf;
    final ExpressionFactory expressionFactory;
    final ExpressionFactory subqueryExpressionFactory;
    final EntityManager em;
    final EntityMetamodelImpl metamodel;
    final AssociationParameterTransformerFactory parameterTransformerFactory;
    final JpaProvider jpaProvider;
    final DbmsDialect dbmsDialect;
    final Map<String, JpqlFunction> registeredFunctions;
    final Map<String, String> registeredFunctionNames;
    final ParameterManager parameterManager;
    final CTEManager cteManager;
    private final JpqlMacroStorage macroStorage;
    private QueryConfiguration queryConfiguration;

    private MainQuery(CriteriaBuilderFactoryImpl cbf, EntityManager em, JpaProvider jpaProvider, DbmsDialect dbmsDialect, Map<String, JpqlFunction> registeredFunctions, Map<String, String> registeredFunctionNames, ParameterManager parameterManager) {
        this.cbf = cbf;
        this.queryConfiguration = cbf.getQueryConfiguration();
        this.macroStorage = new JpqlMacroStorage(cbf.getExpressionFactory().unwrap(AbstractCachingExpressionFactory.class), cbf.getMacroConfiguration());
        this.expressionFactory = new JpqlMacroAwareExpressionFactory(cbf.getExpressionFactory().unwrap(AbstractCachingExpressionFactory.class), this.macroStorage);
        this.subqueryExpressionFactory = new JpqlMacroAwareExpressionFactory(cbf.getSubqueryExpressionFactory().unwrap(AbstractCachingExpressionFactory.class), this.macroStorage);
        this.em = em;
        this.metamodel = cbf.getMetamodel();
        this.jpaProvider = jpaProvider;
        this.dbmsDialect = dbmsDialect;
        this.registeredFunctions = registeredFunctions;
        this.registeredFunctionNames = registeredFunctionNames;
        this.parameterManager = parameterManager;
        this.cteManager = new CTEManager(this);
        this.parameterTransformerFactory = jpaProvider.supportsTransientEntityAsParameter() ? cbf.getTransientEntityParameterTransformerFactory() : new ManagedEntityAssociationParameterTransformerFactory(em, cbf.getTransientEntityParameterTransformerFactory().getToIdTransformer());
    }

    public static MainQuery create(CriteriaBuilderFactoryImpl cbf, EntityManager em, String dbms, DbmsDialect dbmsDialect, Map<String, JpqlFunction> registeredFunctions, Map<String, String> registeredFunctionNames) {
        if (cbf == null) {
            throw new NullPointerException("criteriaBuilderFactory");
        }
        JpaProvider jpaProvider = cbf.getJpaProvider();
        ParameterManager parameterManager = new ParameterManager(jpaProvider, cbf.getMetamodel());
        return new MainQuery(cbf, em, jpaProvider, dbmsDialect, registeredFunctions, registeredFunctionNames, parameterManager);
    }

    public final void registerMacro(String macroName, JpqlMacro jpqlMacro) {
        this.macroStorage.registerMacro(macroName, jpqlMacro);
    }

    public EntityManager getEm() {
        return this.em;
    }

    public EntityMetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    void copyConfiguration(QueryConfiguration configuration) {
        if (configuration instanceof MutableQueryConfiguration) {
            this.queryConfiguration = new MutableQueryConfiguration(configuration);
        }
    }

    public QueryConfiguration getMutableQueryConfiguration() {
        if (!(this.queryConfiguration instanceof MutableQueryConfiguration)) {
            this.queryConfiguration = new MutableQueryConfiguration(this.queryConfiguration);
        }
        return this.queryConfiguration;
    }

    public QueryConfiguration getQueryConfiguration() {
        return this.queryConfiguration;
    }

    public CriteriaBuilderFactoryImpl getCbf() {
        return this.cbf;
    }

    public boolean supportsAdvancedSql() {
        return this.cbf.getExtendedQuerySupport() != null && this.cbf.getExtendedQuerySupport().supportsAdvancedSql();
    }

    public void assertSupportsAdvancedSql(String message) {
        this.assertSupportsAdvancedSql(message, false);
    }

    public void assertSupportsAdvancedSql(String message, boolean inline) {
        if (!(inline || this.cbf.getExtendedQuerySupport() != null && this.cbf.getExtendedQuerySupport().supportsAdvancedSql())) {
            throw new IllegalStateException(message + " There is no extended query support for the JPA provider yet!");
        }
    }
}

