/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EmbeddableSplittingVisitor;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.FunctionalDependencyAnalyzerVisitor;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectManager;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderByManager
extends AbstractManager<ExpressionModifier> {
    private final EmbeddableSplittingVisitor embeddableSplittingVisitor;
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;
    private final FunctionalDependencyAnalyzerVisitor functionalDependencyAnalyzerVisitor;
    private final List<OrderByInfo> orderByInfos = new ArrayList<OrderByInfo>();
    private final SelectManager<?> selectManager;
    private final JoinManager joinManager;
    private final AliasManager aliasManager;
    private final ExpressionFactory expressionFactory;
    private final EntityMetamodel metamodel;
    private final JpaProvider jpaProvider;

    OrderByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, SelectManager<?> selectManager, JoinManager joinManager, AliasManager aliasManager, ExpressionFactory expressionFactory, EmbeddableSplittingVisitor embeddableSplittingVisitor, FunctionalDependencyAnalyzerVisitor functionalDependencyAnalyzerVisitor, EntityMetamodel metamodel, JpaProvider jpaProvider, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.selectManager = selectManager;
        this.joinManager = joinManager;
        this.expressionFactory = expressionFactory;
        this.embeddableSplittingVisitor = embeddableSplittingVisitor;
        this.functionalDependencyAnalyzerVisitor = functionalDependencyAnalyzerVisitor;
        this.metamodel = metamodel;
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
        this.aliasManager = aliasManager;
        this.jpaProvider = jpaProvider;
    }

    void applyFrom(OrderByManager orderByManager, ExpressionCopyContext copyContext) {
        for (OrderByInfo info : orderByManager.orderByInfos) {
            this.orderBy(this.subqueryInitFactory.reattachSubqueries(info.getExpression().copy(copyContext), ClauseType.ORDER_BY), info.ascending, info.nullFirst);
        }
    }

    String[] applyFrom(OrderByManager orderByManager, Map<String, Integer> identifierExpressionStringMap) {
        String[] identifierToUseSelectAliases = new String[identifierExpressionStringMap.size()];
        for (int i = 0; i < orderByManager.orderByInfos.size(); ++i) {
            Expression expression;
            OrderByInfo info = orderByManager.orderByInfos.get(i);
            String potentialSelectAlias = info.getExpressionString();
            AliasInfo aliasInfo = orderByManager.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                Integer selectItemIndex = identifierExpressionStringMap.get(selectInfo.getExpression().toString());
                if (selectItemIndex != null) {
                    String alias;
                    identifierToUseSelectAliases[selectItemIndex.intValue()] = alias = "synth_col_" + selectItemIndex;
                    expression = new PathExpression((PathElementExpression)new PropertyExpression(alias));
                } else {
                    Expression copiedSelectExpression = selectInfo.getExpression().copy(ExpressionCopyContext.EMPTY);
                    if (selectInfo.getExpression() instanceof PathExpression) {
                        expression = copiedSelectExpression;
                    } else {
                        String alias = this.aliasManager.generateRootAlias("bp_generated_alias");
                        ArrayList<Object> args = new ArrayList<Object>(2);
                        args.add(copiedSelectExpression);
                        args.add(new StringLiteral(alias));
                        this.selectManager.select((Expression)new FunctionExpression("alias", args), alias);
                        expression = new PathExpression((PathElementExpression)new PropertyExpression(alias));
                    }
                }
            } else {
                expression = info.getExpression().copy(ExpressionCopyContext.EMPTY);
            }
            this.orderBy(this.subqueryInitFactory.reattachSubqueries(expression, ClauseType.ORDER_BY), info.ascending, info.nullFirst);
        }
        return identifierToUseSelectAliases;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.ORDER_BY;
    }

    public boolean containsOrderBySelectAlias(String alias) {
        if (alias == null || this.orderByInfos.isEmpty()) {
            return false;
        }
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpressionString();
            if (!alias.equals(potentialSelectAlias)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void splitEmbeddables(JoinVisitor joinVisitor) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            int j;
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpressionString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            List<Expression> splittedOffExpressions = this.embeddableSplittingVisitor.splitOff(expr, false);
            if (splittedOffExpressions == null || splittedOffExpressions.isEmpty()) continue;
            if (!this.jpaProvider.supportsSingleValuedAssociationIdExpressions() && joinVisitor != null) {
                ClauseType fromClause = joinVisitor.getFromClause();
                try {
                    joinVisitor.setFromClause(ClauseType.ORDER_BY);
                    for (j = 0; j < splittedOffExpressions.size(); ++j) {
                        splittedOffExpressions.get(j).accept((Expression.Visitor)joinVisitor);
                    }
                }
                finally {
                    joinVisitor.setFromClause(fromClause);
                }
            }
            infos.set(i, new OrderByInfo(splittedOffExpressions.get(0), orderByInfo.ascending, orderByInfo.nullFirst));
            ArrayList<OrderByInfo> newOrderByInfos = new ArrayList<OrderByInfo>(splittedOffExpressions.size() - 1);
            for (j = 1; j < splittedOffExpressions.size(); ++j) {
                newOrderByInfos.add(new OrderByInfo(splittedOffExpressions.get(j), orderByInfo.ascending, orderByInfo.nullFirst));
            }
            infos.addAll(i + 1, newOrderByInfos);
            size += newOrderByInfos.size();
        }
    }

    List<OrderByExpression> getOrderByExpressions(boolean hasCollections, CompoundPredicate rootPredicate, Collection<ResolvedExpression> groupByClauses, JoinVisitor joinVisitor) {
        HashSet<String> clausesRequiredForResultUniqueness;
        if (this.orderByInfos.isEmpty()) {
            return Collections.emptyList();
        }
        if (groupByClauses.isEmpty()) {
            clausesRequiredForResultUniqueness = null;
        } else {
            clausesRequiredForResultUniqueness = new HashSet<String>(groupByClauses.size());
            for (ResolvedExpression groupByClause : groupByClauses) {
                clausesRequiredForResultUniqueness.add(groupByClause.getExpressionString());
            }
        }
        ArrayList<OrderByExpression> realExpressions = new ArrayList<OrderByExpression>(this.orderByInfos.size());
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        boolean resultUnique = false;
        StringBuilder expressionStringBuilder = new StringBuilder();
        this.queryGenerator.setQueryBuffer(expressionStringBuilder);
        this.functionalDependencyAnalyzerVisitor.clear(rootPredicate, this.joinManager.getRoots().get(0), true);
        for (int i = 0; i < size; ++i) {
            boolean resUnique;
            List<Expression> splitOffExpressions;
            boolean unique;
            boolean nullable;
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            String expressionString = orderByInfo.getExpressionString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(expressionString);
            if (aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
                if (clausesRequiredForResultUniqueness != null && !clausesRequiredForResultUniqueness.isEmpty()) {
                    expressionStringBuilder.setLength(0);
                    expr.accept((Expression.Visitor)this.queryGenerator);
                    clausesRequiredForResultUniqueness.remove(expressionStringBuilder.toString());
                }
            } else {
                expr = orderByInfo.getExpression();
                if (clausesRequiredForResultUniqueness != null && !clausesRequiredForResultUniqueness.isEmpty()) {
                    expressionStringBuilder.setLength(0);
                    expr.accept((Expression.Visitor)this.queryGenerator);
                    clausesRequiredForResultUniqueness.remove(expressionStringBuilder.toString());
                }
            }
            boolean bl = nullable = this.joinManager.hasFullJoin() || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), expr);
            if (nullable && clausesRequiredForResultUniqueness != null && !clausesRequiredForResultUniqueness.isEmpty() && !this.jpaProvider.supportsNullPrecedenceExpression()) {
                expressionStringBuilder.insert(0, "CASE WHEN ");
                expressionStringBuilder.append(" IS NULL THEN ");
                if (orderByInfo.nullFirst) {
                    expressionStringBuilder.append("0 ELSE 1 END");
                } else {
                    expressionStringBuilder.append("1 ELSE 0 END");
                }
                clausesRequiredForResultUniqueness.remove(expressionStringBuilder.toString());
            }
            if (!this.joinManager.hasFullJoin() && this.joinManager.getRoots().size() == 1 && !hasCollections) {
                unique = this.functionalDependencyAnalyzerVisitor.analyzeFormsUniqueTuple(expr);
                splitOffExpressions = this.functionalDependencyAnalyzerVisitor.getSplittedOffExpressions();
            } else {
                unique = false;
                splitOffExpressions = this.embeddableSplittingVisitor.splitOff(expr, false);
            }
            resultUnique = !this.joinManager.hasFullJoin() && (resultUnique || unique || clausesRequiredForResultUniqueness != null && clausesRequiredForResultUniqueness.isEmpty());
            boolean bl2 = resUnique = resultUnique || i + 1 == size && this.functionalDependencyAnalyzerVisitor.isResultUnique();
            if (splitOffExpressions == null || splitOffExpressions.isEmpty()) {
                realExpressions.add(new OrderByExpression(orderByInfo.ascending, orderByInfo.nullFirst, expr, nullable, unique, resUnique));
                continue;
            }
            if (this.jpaProvider.supportsSingleValuedAssociationIdExpressions() || joinVisitor == null) {
                for (Expression splitOffExpression : splitOffExpressions) {
                    realExpressions.add(new OrderByExpression(orderByInfo.ascending, orderByInfo.nullFirst, splitOffExpression, nullable, unique, resUnique));
                }
                continue;
            }
            for (Expression splitOffExpression : splitOffExpressions) {
                splitOffExpression.accept((Expression.Visitor)joinVisitor);
                realExpressions.add(new OrderByExpression(orderByInfo.ascending, orderByInfo.nullFirst, splitOffExpression, nullable, unique, resUnique));
            }
        }
        this.queryGenerator.setQueryBuffer(null);
        return realExpressions;
    }

    boolean hasOrderBys() {
        return this.orderByInfos.size() > 0;
    }

    boolean hasComplexOrderBys() {
        if (this.orderByInfos.isEmpty()) {
            return false;
        }
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo;
            OrderByInfo orderByInfo = infos.get(i);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderByInfo.getExpressionString());
            if (!(aliasInfo instanceof SelectInfo) || (selectInfo = (SelectInfo)aliasInfo).getExpression() instanceof PathExpression) continue;
            return true;
        }
        return false;
    }

    void orderBy(Expression expr, boolean ascending, boolean nullFirst) {
        this.orderByInfos.add(new OrderByInfo(expr, ascending, nullFirst));
        this.registerParameterExpressions(expr);
    }

    void acceptVisitor(Expression.Visitor v) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            orderByInfo.getExpression().accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            if (!stopValue.equals(orderByInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            visitor.visit(orderByInfo, ClauseType.ORDER_BY);
        }
    }

    void buildSelectClauses(StringBuilder sb, boolean allClauses, boolean aliasFunction, int[] keysetToSelectIndexMapping) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setClauseType(ClauseType.SELECT);
        this.queryGenerator.setQueryBuffer(sb);
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            if (keysetToSelectIndexMapping != null && keysetToSelectIndexMapping[i] != -1) continue;
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpressionString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                if (!allClauses && selectInfo.getExpression() instanceof PathExpression) continue;
                sb.append(", ");
                if (aliasFunction) {
                    sb.append(this.jpaProvider.getCustomFunctionInvocation("alias", 1));
                    this.queryGenerator.generate(selectInfo.getExpression());
                    sb.append(",'");
                    String subquerySelectAlias = this.selectManager.getSubquerySelectAlias(selectInfo);
                    sb.append(subquerySelectAlias);
                    sb.append("')");
                    sb.append(" AS ").append(subquerySelectAlias);
                    continue;
                }
                this.queryGenerator.generate(selectInfo.getExpression());
                sb.append(" AS ").append(potentialSelectAlias);
                continue;
            }
            if (!allClauses) continue;
            sb.append(", ");
            this.queryGenerator.generate(orderByInfo.getExpression());
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    void buildImplicitGroupByClauses(GroupByManager groupByManager, boolean hasGroupBy, JoinVisitor joinVisitor) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        List<OrderByInfo> infos = this.orderByInfos;
        boolean hasFullJoin = !this.jpaProvider.supportsNullPrecedenceExpression() && this.joinManager.hasFullJoin();
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpressionString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            Set<Expression> extractedGroupByExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(expr, this.getClauseType());
            if (extractedGroupByExpressions.isEmpty()) continue;
            this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
            this.queryGenerator.setQueryBuffer(sb);
            for (Expression extractedExpression : extractedGroupByExpressions) {
                sb.setLength(0);
                this.queryGenerator.generate(extractedExpression);
                String expressionString = sb.toString();
                if (!this.jpaProvider.supportsNullPrecedenceExpression()) {
                    boolean nullable;
                    boolean bl = nullable = hasFullJoin || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), extractedExpression);
                    if (nullable) {
                        NumericLiteral defaultExpression;
                        NumericLiteral resultExpression;
                        sb.insert(0, "CASE WHEN ");
                        sb.append(" IS NULL THEN ");
                        if (orderByInfo.nullFirst) {
                            resultExpression = new NumericLiteral("0", NumericType.INTEGER);
                            defaultExpression = new NumericLiteral("1", NumericType.INTEGER);
                            sb.append("0 ELSE 1 END");
                        } else {
                            resultExpression = new NumericLiteral("1", NumericType.INTEGER);
                            defaultExpression = new NumericLiteral("0", NumericType.INTEGER);
                            sb.append("1 ELSE 0 END");
                        }
                        ArrayList<WhenClauseExpression> whenClauses = new ArrayList<WhenClauseExpression>(1);
                        whenClauses.add(new WhenClauseExpression((Expression)new IsNullPredicate(extractedExpression.copy(ExpressionCopyContext.CLONE)), (Expression)resultExpression));
                        GeneralCaseExpression nullEmulationExpression = new GeneralCaseExpression(whenClauses, (Expression)defaultExpression);
                        String nullPrecedenceEmulationExpression = sb.toString();
                        groupByManager.collect(new ResolvedExpression(nullPrecedenceEmulationExpression, (Expression)nullEmulationExpression), ClauseType.ORDER_BY, hasGroupBy, joinVisitor);
                    }
                }
                groupByManager.collect(new ResolvedExpression(expressionString, extractedExpression), ClauseType.ORDER_BY, hasGroupBy, joinVisitor);
            }
            this.queryGenerator.setClauseType(null);
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.groupByExpressionGatheringVisitor.clear();
    }

    void buildOrderBy(StringBuilder sb, boolean inverseOrder, boolean resolveSelectAliases, boolean resolveSimpleSelectAliases, boolean aliasFunction) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
        this.queryGenerator.setQueryBuffer(sb);
        boolean originalResolveSelectAliases = this.queryGenerator.isResolveSelectAliases();
        this.queryGenerator.setResolveSelectAliases(resolveSelectAliases);
        sb.append(" ORDER BY ");
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            this.applyOrderBy(sb, infos.get(i), inverseOrder, resolveSimpleSelectAliases, aliasFunction);
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
        this.queryGenerator.setResolveSelectAliases(originalResolveSelectAliases);
    }

    private void applyOrderBy(StringBuilder sb, OrderByInfo orderBy, boolean inverseOrder, boolean resolveSimpleSelectAliases, boolean aliasFunction) {
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderBy.getExpressionString());
        boolean hasFullJoin = this.joinManager.hasFullJoin();
        if (this.jpaProvider.supportsNullPrecedenceExpression()) {
            boolean nullable;
            this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
            this.queryGenerator.setQueryBuffer(sb);
            if (aliasInfo instanceof SelectInfo) {
                Expression selectExpression = ((SelectInfo)aliasInfo).getExpression();
                if (resolveSimpleSelectAliases && selectExpression instanceof PathExpression) {
                    this.queryGenerator.generate(selectExpression);
                } else if (aliasFunction && !this.queryGenerator.isResolveSelectAliases()) {
                    sb.append(this.selectManager.getSubquerySelectAlias((SelectInfo)aliasInfo));
                } else {
                    this.queryGenerator.generate(orderBy.getExpression());
                }
                nullable = hasFullJoin || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), selectExpression);
            } else {
                this.queryGenerator.generate(orderBy.getExpression());
                boolean bl = nullable = hasFullJoin || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), orderBy.getExpression());
            }
            if (orderBy.ascending == inverseOrder) {
                sb.append(" DESC");
            } else {
                sb.append(" ASC");
            }
            if (nullable) {
                if (orderBy.nullFirst == inverseOrder) {
                    sb.append(" NULLS LAST");
                } else {
                    sb.append(" NULLS FIRST");
                }
            }
        } else {
            String expression;
            boolean nullable;
            String resolvedExpression;
            StringBuilder expressionSb = new StringBuilder();
            Expression orderExpression = orderBy.getExpression();
            this.queryGenerator.setClauseType(ClauseType.ORDER_BY);
            this.queryGenerator.setQueryBuffer(expressionSb);
            if (aliasInfo instanceof SelectInfo) {
                Expression selectExpression = ((SelectInfo)aliasInfo).getExpression();
                this.queryGenerator.generate(selectExpression);
                resolvedExpression = expressionSb.toString();
                if (resolveSimpleSelectAliases && selectExpression instanceof PathExpression) {
                    orderExpression = selectExpression;
                } else if (aliasFunction) {
                    orderExpression = new PropertyExpression(this.selectManager.getSubquerySelectAlias((SelectInfo)aliasInfo));
                }
                nullable = hasFullJoin || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), selectExpression);
            } else {
                resolvedExpression = null;
                boolean bl = nullable = hasFullJoin || ExpressionUtils.isNullable(this.metamodel, this.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector(), orderExpression);
            }
            if (this.queryGenerator.isResolveSelectAliases() && resolvedExpression != null) {
                expression = resolvedExpression;
            } else {
                expressionSb.setLength(0);
                this.queryGenerator.generate(orderExpression);
                expression = expressionSb.toString();
            }
            String order = orderBy.ascending == inverseOrder ? "DESC" : "ASC";
            String nulls = nullable ? (orderBy.nullFirst == inverseOrder ? "LAST" : "FIRST") : null;
            this.jpaProvider.renderNullPrecedence(sb, expression, resolvedExpression, order, nulls);
        }
        this.queryGenerator.setClauseType(null);
    }

    private static class OrderByInfo
    extends NodeInfo {
        private String expressionString;
        private boolean ascending;
        private boolean nullFirst;

        public OrderByInfo(Expression expression, boolean ascending, boolean nullFirst) {
            super(expression);
            this.expressionString = expression.toString();
            this.ascending = ascending;
            this.nullFirst = nullFirst;
        }

        public String getExpressionString() {
            return this.expressionString;
        }

        @Override
        public void setExpression(Expression expression) {
            super.setExpression(expression);
            this.expressionString = expression.toString();
        }

        @Override
        public void set(Expression expression) {
            super.set(expression);
            this.expressionString = expression.toString();
        }

        @Override
        public OrderByInfo clone() {
            return new OrderByInfo(this.getExpression(), this.ascending, this.nullFirst);
        }
    }
}

