/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.cast;

import com.blazebit.persistence.impl.function.cast.CastFunction;
import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.FunctionRenderContext;

public class DB2CastFunction
extends CastFunction {
    private static final String[] CLOB_RETURNING_FUNCTIONS = new String[]{"json_value(", "json_query("};
    private static final String[] CLOB_COMPATIBLE_CAST_TARGET_TYPES = new String[]{"char", "varchar", "graphic", "vargraphic", "dbclob", "blob", "xml"};

    public DB2CastFunction(Class<?> castType, DbmsDialect dbmsDialect) {
        super(castType, dbmsDialect);
    }

    @Override
    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() != 1 && context.getArgumentsSize() != 2) {
            throw new RuntimeException("The " + this.functionName + " function needs one argument <expression> with an optional second argument <sql-type-name>! args=" + context);
        }
        String effectiveCastTargetType = context.getArgumentsSize() == 1 ? this.defaultSqlCastType : JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(1));
        boolean insertVarcharCast = DB2CastFunction.isClobReturningFunction(context.getArgument(0)) && !DB2CastFunction.isClobCompatibleCastTarget(effectiveCastTargetType);
        context.addChunk("cast(");
        if (insertVarcharCast) {
            context.addChunk("cast(");
        }
        context.addArgument(0);
        if (insertVarcharCast) {
            context.addChunk(" as varchar(32000))");
        }
        context.addChunk(" as ");
        context.addChunk(effectiveCastTargetType);
        context.addChunk(")");
    }

    @Override
    public String getCastExpression(String argument) {
        boolean insertVarcharCast;
        boolean bl = insertVarcharCast = DB2CastFunction.isClobReturningFunction(argument) && !DB2CastFunction.isClobCompatibleCastTarget(this.defaultSqlCastType);
        if (insertVarcharCast) {
            return "cast(cast(" + argument + " as varchar(32000)) as " + this.defaultSqlCastType + ")";
        }
        return "cast(" + argument + " as " + this.defaultSqlCastType + ")";
    }

    private static boolean isClobReturningFunction(String castSource) {
        for (int i = 0; i < CLOB_RETURNING_FUNCTIONS.length; ++i) {
            if (!castSource.toLowerCase().startsWith(CLOB_RETURNING_FUNCTIONS[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isClobCompatibleCastTarget(String castTargetType) {
        for (int i = 0; i < CLOB_COMPATIBLE_CAST_TARGET_TYPES.length; ++i) {
            if (castTargetType.toLowerCase().indexOf(CLOB_COMPATIBLE_CAST_TARGET_TYPES[i]) != 0 || castTargetType.length() != CLOB_COMPATIBLE_CAST_TARGET_TYPES[i].length() && castTargetType.charAt(CLOB_COMPATIBLE_CAST_TARGET_TYPES[i].length()) != '(') continue;
            return true;
        }
        return false;
    }
}

