/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.literal;

import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public abstract class LiteralFunction
implements JpqlFunction {
    protected static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    protected abstract String getFunctionName();

    public void render(FunctionRenderContext functionRenderContext) {
        if (functionRenderContext.getArgumentsSize() != 1) {
            throw new RuntimeException("The " + this.getFunctionName() + " function needs exactly one argument <jdbc_timestamp_literal>! args=" + functionRenderContext);
        }
        functionRenderContext.addChunk(JpqlFunctionUtil.unquoteSingleQuotes(functionRenderContext.getArgument(0)));
    }
}

