/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.tostringjson;

import com.blazebit.persistence.impl.function.chr.ChrFunction;
import com.blazebit.persistence.impl.function.concat.ConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.AbstractGroupConcatFunction;
import com.blazebit.persistence.impl.function.replace.ReplaceFunction;
import com.blazebit.persistence.impl.function.tostringjson.AbstractToStringJsonFunction;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.LateralStyle;
import java.util.Collections;

public class GroupConcatBasedToStringJsonFunction
extends AbstractToStringJsonFunction {
    protected final ConcatFunction concatFunction;
    protected final String preChunk;
    protected final String postChunk;
    protected final String start;
    protected final String end;
    private final boolean coalesceNestedMultiset;
    private final AbstractGroupConcatFunction groupConcatFunction;
    private final LateralStyle lateralStyle;

    public GroupConcatBasedToStringJsonFunction(AbstractGroupConcatFunction groupConcatFunction, ChrFunction chrFunction, ReplaceFunction replaceFunction, ConcatFunction concatFunction, LateralStyle lateralStyle) {
        this(GroupConcatBasedToStringJsonFunction.getPreChunk(concatFunction), GroupConcatBasedToStringJsonFunction.getPostChunk(concatFunction), true, groupConcatFunction, chrFunction, replaceFunction, concatFunction, lateralStyle);
    }

    protected GroupConcatBasedToStringJsonFunction(String preChunk, String postChunk, boolean coalesceNestedMultiset, AbstractGroupConcatFunction groupConcatFunction, ChrFunction chrFunction, ReplaceFunction replaceFunction, ConcatFunction concatFunction, LateralStyle lateralStyle) {
        this.preChunk = preChunk;
        this.postChunk = postChunk;
        this.coalesceNestedMultiset = coalesceNestedMultiset;
        this.groupConcatFunction = groupConcatFunction;
        this.concatFunction = concatFunction;
        this.lateralStyle = lateralStyle;
        String backslash = chrFunction.getEncodedString(Integer.toString(92));
        String backslashB = chrFunction.getEncodedString(Integer.toString(8));
        String backslashF = chrFunction.getEncodedString(Integer.toString(12));
        String backslashN = chrFunction.getEncodedString(Integer.toString(10));
        String backslashR = chrFunction.getEncodedString(Integer.toString(13));
        String backslashT = chrFunction.getEncodedString(Integer.toString(9));
        String backslashBackslash = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + backslash + concatFunction.endConcat();
        String backslashBackslashB = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(8)) + concatFunction.endConcat();
        String backslashBackslashF = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(12)) + concatFunction.endConcat();
        String backslashBackslashN = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(10)) + concatFunction.endConcat();
        String backslashBackslashR = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(13)) + concatFunction.endConcat();
        String backslashBackslashT = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(9)) + concatFunction.endConcat();
        String backslashSlash = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + chrFunction.getEncodedString(Integer.toString(47)) + concatFunction.endConcat();
        String backslashQuote = concatFunction.startConcat() + backslash + concatFunction.concatSeparator() + "'\"'" + concatFunction.endConcat();
        String argument = "\u0000";
        argument = replaceFunction.getReplaceString(argument, backslash, backslashBackslash);
        argument = replaceFunction.getReplaceString(argument, "'/'", backslashSlash);
        argument = replaceFunction.getReplaceString(argument, backslashB, backslashBackslashB);
        argument = replaceFunction.getReplaceString(argument, backslashF, backslashBackslashF);
        argument = replaceFunction.getReplaceString(argument, backslashN, backslashBackslashN);
        argument = replaceFunction.getReplaceString(argument, backslashR, backslashBackslashR);
        argument = replaceFunction.getReplaceString(argument, backslashT, backslashBackslashT);
        argument = replaceFunction.getReplaceString(argument, "'\"'", backslashQuote);
        String[] split = argument.split("\u0000");
        this.start = split[0];
        this.end = split[1];
    }

    private static String getPreChunk(ConcatFunction concatFunction) {
        return "(select " + concatFunction.startConcat() + "'['" + concatFunction.concatSeparator();
    }

    private static String getPostChunk(ConcatFunction concatFunction) {
        return concatFunction.concatSeparator() + "']'" + concatFunction.endConcat();
    }

    @Override
    public void render(FunctionRenderContext context, String[] fields, String[] selectItemExpressions, String subquery, int fromIndex) {
        int orderByIndex = SqlUtils.indexOfOrderBy(subquery, fromIndex);
        if (orderByIndex == -1) {
            context.addChunk(this.preChunk);
            this.groupConcatFunction.render(context, new AbstractGroupConcatFunction.GroupConcat(false, this.createGroupConcatArgument(fields, selectItemExpressions, fromIndex), Collections.emptyList(), ","));
            context.addChunk(this.postChunk);
            context.addChunk(subquery.substring(fromIndex));
        } else {
            int orderByEndIndex;
            int offsetIndex;
            String limit = null;
            String offset = null;
            int limitIndex = SqlUtils.indexOfLimit(subquery, orderByIndex);
            if (limitIndex == -1) {
                offsetIndex = subquery.indexOf(" offset ", orderByIndex);
                int fetchFirstIndex = SqlUtils.indexOfFetchFirst(subquery, orderByIndex);
                int endIndex = subquery.length() - 1;
                if (offsetIndex != -1) {
                    offset = fetchFirstIndex == -1 ? subquery.substring(offsetIndex + " offset ".length(), endIndex) : subquery.substring(offsetIndex + " offset ".length(), fetchFirstIndex);
                    endIndex = Math.min(endIndex, offsetIndex);
                }
                if (fetchFirstIndex != -1) {
                    int rowsOnlyIndex = subquery.indexOf(" rows only", fetchFirstIndex + " fetch first ".length() + 1);
                    limit = subquery.substring(fetchFirstIndex + " fetch first ".length(), rowsOnlyIndex);
                    endIndex = Math.min(endIndex, fetchFirstIndex);
                }
                orderByEndIndex = endIndex;
            } else {
                orderByEndIndex = limitIndex;
                offsetIndex = subquery.indexOf(" offset ", limitIndex);
                if (offsetIndex == -1) {
                    int commaIndex = subquery.indexOf(44, limitIndex);
                    if (commaIndex == -1) {
                        limit = subquery.substring(limitIndex + " limit ".length(), subquery.length() - 1);
                    } else {
                        offset = subquery.substring(limitIndex + " limit ".length(), commaIndex);
                        limit = subquery.substring(commaIndex + 1, subquery.length() - 1);
                    }
                } else {
                    limit = subquery.substring(limitIndex + " limit ".length(), offsetIndex);
                    offset = subquery.substring(offsetIndex, subquery.length() - 1);
                }
            }
            if (limit == null) {
                context.addChunk(this.preChunk);
                this.groupConcatFunction.render(context, new AbstractGroupConcatFunction.GroupConcat(false, this.createGroupConcatArgument(fields, selectItemExpressions, fromIndex), Collections.emptyList(), ","));
                context.addChunk(" OVER (");
                context.addChunk(subquery.substring(orderByIndex));
                context.addChunk(this.postChunk);
                context.addChunk(subquery.substring(fromIndex, orderByIndex));
                context.addChunk(")");
            } else if (this.lateralStyle == LateralStyle.NONE) {
                context.addChunk(this.preChunk);
                this.groupConcatFunction.render(context, new AbstractGroupConcatFunction.GroupConcat(false, this.createGroupConcatArgument(fields, selectItemExpressions, fromIndex), Collections.emptyList(), ","));
                context.addChunk(" OVER (");
                context.addChunk(subquery.substring(orderByIndex, orderByEndIndex));
                if (offset == null) {
                    context.addChunk(" ROWS BETWEEN CURRENT ROW AND (");
                    context.addChunk(limit);
                    context.addChunk(" - 1) FOLLOWING");
                } else {
                    context.addChunk(" ROWS BETWEEN ");
                    context.addChunk(limit);
                    context.addChunk(" FOLLOWING AND ");
                    context.addChunk(offset);
                    context.addChunk(" FOLLOWING");
                }
                context.addChunk(")");
                context.addChunk(this.postChunk);
                context.addChunk(subquery.substring(fromIndex, orderByEndIndex));
                context.addChunk(" limit 1)");
            } else {
                context.addChunk(this.preChunk);
                this.groupConcatFunction.render(context, new AbstractGroupConcatFunction.GroupConcat(false, this.createGroupConcatArgument(fields, fields, fromIndex), Collections.emptyList(), ","));
                context.addChunk(this.postChunk);
                context.addChunk(" from lateral(select ");
                for (int i = 0; i < fields.length; ++i) {
                    if (i != 0) {
                        context.addChunk(",");
                    }
                    context.addChunk(selectItemExpressions[i]);
                    context.addChunk(" ");
                    context.addChunk(fields[i]);
                }
                context.addChunk(subquery.substring(fromIndex));
                context.addChunk(" tmp)");
            }
        }
    }

    private String createGroupConcatArgument(String[] fields, String[] selectItemExpressions, int fromIndex) {
        StringBuilder sb = new StringBuilder(fromIndex);
        this.render(sb, fields, selectItemExpressions);
        return sb.toString();
    }

    protected void render(StringBuilder sb, String[] fields, String[] selectItemExpressions) {
        sb.append(this.concatFunction.startConcat());
        sb.append("'{\"");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sb.append(this.concatFunction.concatSeparator());
                sb.append("',\"");
            }
            sb.append(fields[i]);
            sb.append("\":'");
            sb.append(this.concatFunction.concatSeparator());
            if (selectItemExpressions[i].startsWith(this.preChunk)) {
                if (this.coalesceNestedMultiset) {
                    sb.append(this.coalesceStart());
                    sb.append(selectItemExpressions[i]);
                    sb.append(this.coalesceEnd(fields[i]));
                    continue;
                }
                sb.append(selectItemExpressions[i]);
                continue;
            }
            sb.append(this.coalesceStart());
            sb.append(this.concatFunction.startConcat());
            sb.append("'\"'");
            sb.append(this.concatFunction.concatSeparator());
            sb.append(this.start);
            sb.append(selectItemExpressions[i]);
            sb.append(this.end);
            sb.append(this.concatFunction.concatSeparator());
            sb.append("'\"'");
            sb.append(this.concatFunction.endConcat());
            sb.append(this.coalesceEnd(fields[i]));
        }
        sb.append(this.concatFunction.concatSeparator());
        sb.append("'}'");
        sb.append(this.concatFunction.endConcat());
    }

    protected String coalesceStart() {
        return "coalesce(";
    }

    protected String coalesceEnd(String field) {
        return ",'null')";
    }
}

