/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ParameterValueTransformer;
import com.blazebit.persistence.impl.ValuesParameterBinder;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.query.TypedQueryWrapper;
import com.blazebit.persistence.impl.util.SetView;
import com.blazebit.persistence.spi.CteQueryWrapper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;

public abstract class AbstractCustomQuery<T>
implements Query,
CteQueryWrapper {
    protected final QuerySpecification<T> querySpecification;
    protected final Map<String, ParameterValueTransformer> transformers;
    protected final Map<String, ValuesParameter> valuesParameters;
    protected final Map<String, String> valuesElementParameters;
    protected final Map<String, Parameter<?>> parameters;
    protected final Map<String, ValueBinder> valueBinders;
    protected final Map<ParameterExpression<?>, String> criteriaNameMapping;
    protected int firstResult;
    protected int maxResults = Integer.MAX_VALUE;

    public AbstractCustomQuery(QuerySpecification<T> querySpecification, Map<ParameterExpression<?>, String> criteriaNameMapping, Map<String, ParameterValueTransformer> transformers, Map<String, String> valuesParameters, Map<String, ValuesParameterBinder> valuesBinders) {
        this.querySpecification = querySpecification;
        this.criteriaNameMapping = criteriaNameMapping;
        HashMap<String, ValuesParameter> valuesParameterMap = new HashMap<String, ValuesParameter>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.valueBinders = new HashMap<String, ValueBinder>(parameters.size());
        for (Parameter<?> p : querySpecification.getParameters()) {
            String name = p.getName();
            ValuesParameterBinder valuesParameterBinder = valuesBinders.get(name);
            if (valuesParameterBinder == null) {
                if (p instanceof ParameterManager.ParameterImpl && ((ParameterManager.ParameterImpl)p).getCriteriaParameter() != null) {
                    parameters.put(name, ((ParameterManager.ParameterImpl)p).getCriteriaParameter());
                } else {
                    parameters.put(name, p);
                }
                this.valueBinders.put(name, null);
                continue;
            }
            ValuesParameter param = new ValuesParameter(name, valuesParameterBinder);
            parameters.put(name, param);
            this.valueBinders.put(name, null);
            valuesParameterMap.put(name, param);
        }
        HashMap<String, ParameterValueTransformer> newTransformers = new HashMap<String, ParameterValueTransformer>(transformers.size());
        for (Map.Entry<String, ParameterValueTransformer> entry : transformers.entrySet()) {
            newTransformers.put(entry.getKey(), entry.getValue().forQuery(this));
        }
        this.transformers = Collections.unmodifiableMap(newTransformers);
        this.valuesParameters = Collections.unmodifiableMap(valuesParameterMap);
        this.valuesElementParameters = Collections.unmodifiableMap(valuesParameters);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public QuerySpecification<T> getQuerySpecification() {
        return this.querySpecification;
    }

    public String getSql() {
        return this.querySpecification.getSql();
    }

    public List<Query> getParticipatingQueries() {
        return this.querySpecification.getParticipatingQueries();
    }

    public Query setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Query setFirstResult(int startPosition) {
        this.firstResult = startPosition;
        return this;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    /*
     * WARNING - void declaration
     */
    protected void bindParameters() {
        HashSet<String> missingParameters = null;
        for (Query query : this.querySpecification.getParticipatingQueries()) {
            void var3_3;
            for (Parameter p : query.getParameters()) {
                String name = p.getName();
                String valuesName = this.valuesElementParameters.get(name);
                if (valuesName == null) {
                    ValueBinder valueBinder = this.valueBinders.get(name);
                    if (valueBinder == null) {
                        if (missingParameters == null) {
                            missingParameters = new HashSet<String>();
                        }
                        missingParameters.add(name);
                        continue;
                    }
                    valueBinder.bind(query, name);
                    continue;
                }
                ValuesParameter valuesParameter = this.valuesParameters.get(valuesName);
                if (valuesParameter.getValue() == null) {
                    if (missingParameters == null) {
                        missingParameters = new HashSet();
                    }
                    missingParameters.add(name);
                    continue;
                }
                valuesParameter.bind(query);
            }
            if (query instanceof TypedQueryWrapper) {
                TypedQuery typedQuery = ((TypedQueryWrapper)query).getDelegate();
            }
            if (!(var3_3 instanceof AbstractCustomQuery)) continue;
            ((AbstractCustomQuery)var3_3).bindParameters();
        }
        if (missingParameters != null && !missingParameters.isEmpty()) {
            Iterator iterator = missingParameters.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String valuesName = this.valuesElementParameters.get(string);
                if (valuesName == null) {
                    if (this.valueBinders.get(string) == null) continue;
                    iterator.remove();
                    continue;
                }
                if (this.valuesParameters.get(valuesName).getValue() == null) continue;
                iterator.remove();
            }
            if (!missingParameters.isEmpty()) {
                throw new IllegalArgumentException("The following parameters have not been set: " + missingParameters);
            }
        }
    }

    private String getName(Parameter<?> parameter) {
        return this.criteriaNameMapping != null && parameter instanceof ParameterExpression ? this.criteriaNameMapping.get(parameter) : parameter.getName();
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        this.setParameter(this.getName(param), value);
        return this;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.setParameter(this.getName(param), value, temporalType);
        return this;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.setParameter(this.getName(param), value, temporalType);
        return this;
    }

    public Query setParameter(String name, Object value) {
        ValuesParameter valuesParameter = this.valuesParameters.get(name);
        if (valuesParameter == null) {
            if (!this.parameters.containsKey(name)) {
                throw new IllegalArgumentException("Invalid or unknown parameter with name: " + name);
            }
            ParameterValueTransformer transformer = this.transformers.get(name);
            if (transformer != null) {
                value = transformer.transform(value);
            }
            if (value instanceof Collection) {
                this.querySpecification.onCollectionParameterChange(name, (Collection)value);
            }
            this.valueBinders.put(name, new DefaultValueBinder(value));
        } else {
            valuesParameter.setValue(value);
        }
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        if (!this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("Invalid or unknown parameter with name: " + name);
        }
        this.valueBinders.put(name, new CalendarValueBinder(value, temporalType));
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        if (!this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("Invalid or unknown parameter with name: " + name);
        }
        this.valueBinders.put(name, new DateValueBinder(value, temporalType));
        return this;
    }

    public Query setParameter(int position, Object value) {
        return this.setParameter(Integer.toString(position), value);
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.setParameter(Integer.toString(position), value, temporalType);
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        return this.setParameter(Integer.toString(position), value, temporalType);
    }

    public Set<Parameter<?>> getParameters() {
        return new SetView(this.parameters.values());
    }

    public Parameter<?> getParameter(String name) {
        Parameter<?> param = this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("Couldn't find parameter with name '" + name + "'!");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> p = this.getParameter(name);
        if (!type.isAssignableFrom(p.getParameterType())) {
            throw new IllegalArgumentException("Parameter '" + name + "' is not assignable to '" + type.getName() + "'!");
        }
        return p;
    }

    public Parameter<?> getParameter(int position) {
        throw new IllegalArgumentException("Positional parameters unsupported!");
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new IllegalArgumentException("Positional parameters unsupported!");
    }

    public boolean isBound(Parameter<?> param) {
        String name = this.getName(param);
        ValuesParameter valuesParameter = this.valuesParameters.get(name);
        if (valuesParameter != null) {
            return valuesParameter.getValue() != null;
        }
        return this.valueBinders.get(name) != null;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.getParameterValue(this.getName(param));
    }

    public Object getParameterValue(String name) {
        ValuesParameter valuesParameter = this.valuesParameters.get(name);
        if (valuesParameter != null) {
            return valuesParameter.getValue();
        }
        ValueBinder valueBinder = this.valueBinders.get(name);
        return valueBinder == null ? null : valueBinder.getValue();
    }

    public Object getParameterValue(int position) {
        throw new IllegalArgumentException("Positional parameters unsupported!");
    }

    static class ValuesParameter
    implements Parameter<Collection> {
        private final String name;
        private final ValuesParameterBinder binder;
        private Collection<Object> value;

        public ValuesParameter(String name, ValuesParameterBinder binder) {
            this.name = name;
            this.binder = binder;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return null;
        }

        public Class<Collection> getParameterType() {
            return Collection.class;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("null not allowed for VALUES parameter!");
            }
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Value for VALUES parameter must be a collection! Unsupported type: " + value.getClass());
            }
            Collection collection = (Collection)value;
            if (collection.size() > this.binder.size()) {
                throw new IllegalArgumentException("The size of the collection must be lower or equal to the specified size for the VALUES clause.");
            }
            this.value = collection;
        }

        public void bind(Query query) {
            this.binder.bind(query, this.value);
        }
    }

    static interface ValueBinder {
        public void bind(Query var1, String var2);

        public Object getValue();
    }

    static class DefaultValueBinder
    implements ValueBinder {
        private final Object value;

        public DefaultValueBinder(Object value) {
            this.value = value;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    static class CalendarValueBinder
    implements ValueBinder {
        private final Calendar value;
        private final TemporalType temporalType;

        public CalendarValueBinder(Calendar value, TemporalType temporalType) {
            this.value = value;
            this.temporalType = temporalType;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.temporalType);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    static class DateValueBinder
    implements ValueBinder {
        private final Date value;
        private final TemporalType temporalType;

        public DateValueBinder(Date value, TemporalType temporalType) {
            this.value = value;
            this.temporalType = temporalType;
        }

        @Override
        public void bind(Query query, String name) {
            query.setParameter(name, this.value, this.temporalType);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

