/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.plan.DefaultModificationQueryPlan;
import com.blazebit.persistence.impl.plan.DefaultSelectQueryPlan;
import com.blazebit.persistence.impl.plan.ModificationQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class DefaultQuerySpecification
implements QuerySpecification {
    private final DbmsStatementType statementType;
    private final Query query;
    private final EntityManager em;
    private final Set<String> parameterListNames;
    private final ExtendedQuerySupport extendedQuerySupport;

    public DefaultQuerySpecification(DbmsStatementType statementType, Query query, EntityManager em, Set<String> parameterListNames, ExtendedQuerySupport extendedQuerySupport) {
        this.statementType = statementType;
        this.query = query;
        this.em = em;
        this.parameterListNames = parameterListNames;
        this.extendedQuerySupport = extendedQuerySupport;
    }

    @Override
    public ModificationQueryPlan createModificationPlan(int firstResult, int maxResults) {
        return new DefaultModificationQueryPlan(this.statementType, this.query, firstResult, maxResults);
    }

    public SelectQueryPlan createSelectPlan(int firstResult, int maxResults) {
        return new DefaultSelectQueryPlan(this.query, firstResult, maxResults);
    }

    @Override
    public String getSql() {
        return this.extendedQuerySupport.getSql(this.em, this.query);
    }

    @Override
    public List<Query> getParticipatingQueries() {
        return Arrays.asList(this.query);
    }

    @Override
    public Collection<? extends Parameter<?>> getParameters() {
        return this.query.getParameters();
    }

    @Override
    public Map<String, String> getAddedCtes() {
        return null;
    }

    @Override
    public Query getBaseQuery() {
        return this.query;
    }

    public void onCollectionParameterChange(String parameterName, Collection value) {
        if (this.parameterListNames.contains(parameterName)) {
            this.query.setParameter(parameterName, (Object)value);
        }
    }
}

