/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.impl.util.AbstractPatternFinder;

public class BoyerMooreCaseInsensitiveAsciiFirstPatternFinder
extends AbstractPatternFinder {
    private static final int RADIX = 256;
    private final int[] right;
    private final char[] pattern;

    public BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(String pattern) {
        int i;
        int length = pattern.length();
        this.pattern = new char[length];
        this.right = new int[256];
        for (i = 0; i < 256; ++i) {
            this.right[i] = -1;
        }
        i = 0;
        while (i < length) {
            char c;
            this.pattern[i] = c = Character.toLowerCase(pattern.charAt(i));
            this.right[c] = i++;
        }
    }

    @Override
    public int indexIn(char[] text, int start, int end) {
        int skip;
        int m = this.pattern.length;
        int n = Math.min(text.length, end);
        for (int i = start; i <= n - m; i += skip) {
            skip = 0;
            for (int j = m - 1; j >= 0; --j) {
                char c = Character.toLowerCase(text[i + j]);
                if (this.pattern[j] == c) continue;
                skip = Math.max(1, j - this.right[c]);
                break;
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexIn(CharSequence text, int start, int end) {
        int skip;
        int m = this.pattern.length;
        int n = Math.min(text.length(), end);
        for (int i = start; i <= n - m; i += skip) {
            skip = 0;
            for (int j = m - 1; j >= 0; --j) {
                char c = Character.toLowerCase(text.charAt(i + j));
                if (this.pattern[j] == c) continue;
                skip = Math.max(1, j - this.right[c]);
                break;
            }
            if (skip != 0) continue;
            return i;
        }
        return -1;
    }
}

