/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view;

import com.blazebit.persistence.OrderByBuilder;
import com.blazebit.persistence.view.Sorter;

public final class Sorters {
    private Sorters() {
    }

    public static Sorter sorter(boolean ascending, boolean nullsFirst) {
        return new DefaultSorter(ascending, nullsFirst);
    }

    public static Sorter ascending(boolean nullsFirst) {
        return new DefaultSorter(true, nullsFirst);
    }

    public static Sorter descending(boolean nullsFirst) {
        return new DefaultSorter(false, nullsFirst);
    }

    public static Sorter ascending() {
        return new DefaultSorter(true, false);
    }

    public static Sorter descending() {
        return new DefaultSorter(false, false);
    }

    private static class DefaultSorter
    implements Sorter {
        private final boolean ascending;
        private final boolean nullFirst;

        DefaultSorter(boolean ascending, boolean nullFirst) {
            this.ascending = ascending;
            this.nullFirst = nullFirst;
        }

        @Override
        public <T extends OrderByBuilder<T>> T apply(T sortable, String expression) {
            return (T)sortable.orderBy(expression, this.ascending, this.nullFirst);
        }
    }
}

