/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RecordingReplacingIterator<E>
implements Iterator<E> {
    private final RecordingCollection<?, E> recordingCollection;
    private final Iterator<E> iterator;
    private E current;
    private List<E> replacedElements;

    public RecordingReplacingIterator(RecordingCollection<?, E> recordingCollection) {
        this.recordingCollection = recordingCollection;
        this.iterator = recordingCollection.delegate.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (this.replacedElements != null) {
            this.current = this.iterator.next();
            this.replacedElements.add(this.current);
            this.iterator.remove();
            return this.current;
        }
        this.current = this.iterator.next();
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void replace() {
        if (this.replacedElements == null) {
            this.replacedElements = new ArrayList();
            this.iterator.remove();
        } else {
            this.replacedElements.remove(this.replacedElements.size() - 1);
        }
    }

    public void reset() {
        if (this.replacedElements != null) {
            Object delegate = this.recordingCollection.getDelegate();
            if (this.current != null && (this.replacedElements.isEmpty() || this.current != this.replacedElements.get(this.replacedElements.size() - 1))) {
                delegate.add(this.current);
            }
            delegate.addAll(this.replacedElements);
        }
    }

    public void add(E object) {
        if (this.replacedElements != null) {
            this.replacedElements.add(object);
            this.current = null;
        }
    }

    public E getCurrent() {
        return this.current;
    }
}

