/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.BatchFetch;
import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.EmptyFlatViewCreation;
import com.blazebit.persistence.view.Limit;
import com.blazebit.persistence.view.MultiCollectionMapping;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelUtils;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class AbstractAnnotationAttributeMappingReader {
    protected final MetamodelBootContext context;

    public AbstractAnnotationAttributeMappingReader(MetamodelBootContext context) {
        this.context = context;
    }

    protected void applyCommonMappings(AttributeMapping attributeMapping, AnnotatedElement annotatedElement) {
        Limit limit;
        EmptyFlatViewCreation emptyFlatViewCreation;
        CollectionMapping collectionMapping = annotatedElement.getAnnotation(CollectionMapping.class);
        Class<?> collectionType = attributeMapping.getDeclaredType();
        if (collectionMapping != null && collectionMapping.ignoreIndex() && Map.class.isAssignableFrom(collectionType)) {
            this.context.addError("Illegal ignoreIndex mapping for the " + attributeMapping.getErrorLocation());
        }
        if (collectionMapping != null) {
            Class c = collectionMapping.comparator();
            Class comparatorClass = c == Comparator.class ? null : c;
            if (comparatorClass != null || MetamodelUtils.isSorted(collectionType)) {
                if (collectionMapping.ignoreIndex()) {
                    this.context.addError("Illegal ignoreIndex mapping for the sorted " + attributeMapping.getErrorLocation());
                }
                if (collectionMapping.ordered()) {
                    this.context.addError("Illegal ordered mapping for the sorted " + attributeMapping.getErrorLocation());
                }
                attributeMapping.setContainerSorted(comparatorClass);
            } else if (collectionType == List.class) {
                if (collectionMapping.ignoreIndex()) {
                    attributeMapping.setContainerDefault();
                }
            } else if (collectionMapping.ordered()) {
                attributeMapping.setContainerOrdered();
            } else {
                attributeMapping.setContainerDefault();
            }
            attributeMapping.setForceUniqueness(collectionMapping.forceUnique());
        } else if (collectionType != List.class) {
            if (MetamodelUtils.isSorted(collectionType)) {
                attributeMapping.setContainerSorted(null);
            } else {
                attributeMapping.setContainerDefault();
            }
        }
        MultiCollectionMapping multiCollectionMapping = annotatedElement.getAnnotation(MultiCollectionMapping.class);
        PluralAttribute.ElementCollectionType elementCollectionType = attributeMapping.getElementCollectionType();
        if (multiCollectionMapping != null && elementCollectionType == null) {
            this.context.addError("Illegal @MultiCollectionMapping mapping on non-multi collection " + attributeMapping.getErrorLocation());
        }
        if (multiCollectionMapping != null) {
            Class c = multiCollectionMapping.comparator();
            Class comparatorClass = c == Comparator.class ? null : c;
            if (comparatorClass != null || elementCollectionType == PluralAttribute.ElementCollectionType.SORTED_SET) {
                if (multiCollectionMapping.ordered()) {
                    this.context.addError("Illegal ordered mapping for the sorted element collection " + attributeMapping.getErrorLocation());
                }
                attributeMapping.setElementCollectionSorted(comparatorClass);
            } else if (multiCollectionMapping.ordered()) {
                attributeMapping.setElementCollectionOrdered();
            } else {
                attributeMapping.setElementCollectionDefault();
            }
            attributeMapping.setElementCollectionForceUniqueness(multiCollectionMapping.forceUnique());
        } else if (elementCollectionType == PluralAttribute.ElementCollectionType.SORTED_SET) {
            attributeMapping.setContainerSorted(null);
        } else if (elementCollectionType != null) {
            attributeMapping.setContainerDefault();
        }
        BatchFetch batchFetch = annotatedElement.getAnnotation(BatchFetch.class);
        if (batchFetch != null) {
            attributeMapping.setDefaultBatchSize(batchFetch.size());
        }
        if ((emptyFlatViewCreation = annotatedElement.getAnnotation(EmptyFlatViewCreation.class)) != null) {
            attributeMapping.setCreateEmptyFlatViews(emptyFlatViewCreation.value());
        }
        if ((limit = annotatedElement.getAnnotation(Limit.class)) != null) {
            attributeMapping.setLimit(limit.limit(), limit.offset(), Arrays.asList(limit.order()));
        }
    }

    protected PluralAttribute.ElementCollectionType getElementCollectionType(Class<?> elementType) {
        if (List.class.isAssignableFrom(elementType)) {
            return PluralAttribute.ElementCollectionType.LIST;
        }
        if (SortedSet.class.isAssignableFrom(elementType)) {
            return PluralAttribute.ElementCollectionType.SORTED_SET;
        }
        if (Set.class.isAssignableFrom(elementType)) {
            return PluralAttribute.ElementCollectionType.SET;
        }
        return PluralAttribute.ElementCollectionType.COLLECTION;
    }
}

