/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FromBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.StaticPathCorrelationProvider;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.NullTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.CorrelatedSubviewJoinTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.JoinCorrelationBuilder;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Map;

public class CorrelatedSubviewJoinTupleTransformerFactory
implements TupleTransformerFactory {
    private final ViewTypeObjectBuilderTemplate<Object[]> template;
    private final CorrelationProviderFactory correlationProviderFactory;
    private final String correlationBasis;
    private final String correlationAlias;
    private final String correlationExternalAlias;
    private final String attributePath;
    private final String joinBase;
    private final String embeddingViewPath;
    private final String[] fetches;
    private final Limiter limiter;

    public CorrelatedSubviewJoinTupleTransformerFactory(ViewTypeObjectBuilderTemplate<Object[]> template, CorrelationProviderFactory correlationProviderFactory, String correlationAlias, String joinBase, String correlationBasis, String correlationExternalAlias, String attributePath, String embeddingViewPath, String[] fetches, Limiter limiter) {
        this.template = template;
        this.correlationProviderFactory = correlationProviderFactory;
        this.correlationAlias = correlationAlias;
        this.correlationBasis = correlationBasis;
        this.correlationExternalAlias = correlationExternalAlias;
        this.attributePath = attributePath;
        this.joinBase = joinBase;
        this.embeddingViewPath = embeddingViewPath;
        this.fetches = fetches;
        this.limiter = limiter;
    }

    @Override
    public int getConsumeStartIndex() {
        return -1;
    }

    @Override
    public int getConsumeEndIndex() {
        return -1;
    }

    @Override
    public TupleTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
        if (!entityViewConfiguration.hasSubFetches(this.attributePath)) {
            return new NullTupleTransformer(this.template, this.template.getTupleOffset());
        }
        if (parameterHolder instanceof FullQueryBuilder) {
            FullQueryBuilder queryBuilder = (FullQueryBuilder)parameterHolder;
            CorrelationProvider provider = this.correlationProviderFactory.create(parameterHolder, optionalParameters);
            JoinCorrelationBuilder correlationBuilder = new JoinCorrelationBuilder(parameterHolder, optionalParameters, (FromBuilder<?>)queryBuilder, this.joinBase, this.correlationAlias, this.correlationExternalAlias, this.attributePath, JoinType.LEFT, this.limiter);
            int originalFirstResult = -1;
            int originalMaxResults = -1;
            if (queryBuilder instanceof LimitBuilder) {
                originalFirstResult = ((LimitBuilder)queryBuilder).getFirstResult();
                originalMaxResults = ((LimitBuilder)queryBuilder).getMaxResults();
            }
            ViewJpqlMacro viewJpqlMacro = entityViewConfiguration.getViewJpqlMacro();
            EmbeddingViewJpqlMacro embeddingViewJpqlMacro = entityViewConfiguration.getEmbeddingViewJpqlMacro();
            String oldViewPath = viewJpqlMacro.getViewPath();
            String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
            if (!(provider instanceof StaticPathCorrelationProvider)) {
                viewJpqlMacro.setViewPath(correlationBuilder.getCorrelationAlias());
                embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
            }
            provider.applyCorrelation((CorrelationBuilder)correlationBuilder, this.correlationBasis);
            if (queryBuilder instanceof LimitBuilder && (originalFirstResult != ((LimitBuilder)queryBuilder).getFirstResult() || originalMaxResults != ((LimitBuilder)queryBuilder).getMaxResults())) {
                throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
            }
            correlationBuilder.finish();
            if (!(provider instanceof StaticPathCorrelationProvider)) {
                viewJpqlMacro.setViewPath(oldViewPath);
                embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
            }
            if (this.fetches.length != 0) {
                for (int i = 0; i < this.fetches.length; ++i) {
                    queryBuilder.fetch(correlationBuilder.getCorrelationAlias() + "." + this.fetches[i]);
                }
            }
            ObjectBuilder<Object[]> objectBuilder = this.template.createObjectBuilder(parameterHolder, optionalParameters, entityViewConfiguration, 0, true, false);
            return new CorrelatedSubviewJoinTupleTransformer(this.template, objectBuilder);
        }
        throw new UnsupportedOperationException("Converting views with correlated attributes isn't supported!");
    }
}

