/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EmbeddableAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.ArrayList;

public class UnmappedOwnerAwareDeleter {
    private final ViewToEntityMapper idMapper;
    private final UnmappedAttributeCascadeDeleter[] routedPreDeleters;
    private final UnmappedAttributeCascadeDeleter[] routedPostDeleters;

    public UnmappedOwnerAwareDeleter(DirtyAttributeFlusher<?, ?, ?> idFlusher, UnmappedAttributeCascadeDeleter[] routedPreDeleters, UnmappedAttributeCascadeDeleter[] routedPostDeleters) {
        this.idMapper = idFlusher instanceof EmbeddableAttributeFlusher ? ((EmbeddableAttributeFlusher)idFlusher).getViewToEntityMapper() : null;
        this.routedPreDeleters = routedPreDeleters;
        this.routedPostDeleters = routedPostDeleters;
    }

    private UnmappedOwnerAwareDeleter(ViewToEntityMapper idMapper, UnmappedAttributeCascadeDeleter[] routedPreDeleters, UnmappedAttributeCascadeDeleter[] routedPostDeleters) {
        this.idMapper = idMapper;
        this.routedPreDeleters = routedPreDeleters;
        this.routedPostDeleters = routedPostDeleters;
    }

    public void preDelete(UpdateContext context, EntityViewProxy view) {
        if (this.routedPreDeleters != null && this.routedPreDeleters.length != 0) {
            Object entityId = view.$$_getId();
            if (this.idMapper != null) {
                entityId = this.idMapper.applyToEntity(context, null, entityId);
            }
            for (int i = 0; i < this.routedPreDeleters.length; ++i) {
                this.routedPreDeleters[i].removeByOwnerId(context, entityId);
            }
        }
    }

    public void postDelete(UpdateContext context, EntityViewProxy view) {
        if (this.routedPostDeleters != null && this.routedPostDeleters.length != 0) {
            Object entityId = view.$$_getId();
            if (this.idMapper != null) {
                entityId = this.idMapper.applyToEntity(context, null, entityId);
            }
            for (int i = 0; i < this.routedPostDeleters.length; ++i) {
                this.routedPostDeleters[i].removeByOwnerId(context, entityId);
            }
        }
    }

    public UnmappedOwnerAwareDeleter getSubDeleter(DirtyAttributeFlusher<?, Object, Object> flusher) {
        if (!(flusher instanceof EmbeddableAttributeFlusher)) {
            return null;
        }
        EmbeddableAttributeFlusher embeddableFlusher = (EmbeddableAttributeFlusher)flusher;
        ArrayList<UnmappedAttributeCascadeDeleter> subPreDeleters = new ArrayList<UnmappedAttributeCascadeDeleter>();
        ArrayList<UnmappedAttributeCascadeDeleter> subPostDeleters = new ArrayList<UnmappedAttributeCascadeDeleter>();
        if (this.routedPreDeleters != null && this.routedPreDeleters.length != 0) {
            for (UnmappedAttributeCascadeDeleter routedDeleter : this.routedPreDeleters) {
                if (!routedDeleter.getAttributeValuePath().startsWith(embeddableFlusher.getMapping())) continue;
                subPreDeleters.add(routedDeleter);
            }
        }
        if (this.routedPostDeleters != null && this.routedPostDeleters.length != 0) {
            for (UnmappedAttributeCascadeDeleter routedDeleter : this.routedPostDeleters) {
                if (!routedDeleter.getAttributeValuePath().startsWith(embeddableFlusher.getMapping())) continue;
                subPostDeleters.add(routedDeleter);
            }
        }
        if (subPreDeleters.isEmpty() && subPostDeleters.isEmpty()) {
            return null;
        }
        return new UnmappedOwnerAwareDeleter(this.idMapper, subPreDeleters.isEmpty() ? null : subPreDeleters.toArray(new UnmappedAttributeCascadeDeleter[subPreDeleters.size()]), subPostDeleters.isEmpty() ? null : subPostDeleters.toArray(new UnmappedAttributeCascadeDeleter[subPostDeleters.size()]));
    }
}

