/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.util.Iterator;
import java.util.Map;

public class RecordingEntrySetIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final RecordingMap<Map<K, V>, K, V> recordingMap;
    private final Iterator<Map.Entry<K, V>> iterator;
    private Object current;

    public RecordingEntrySetIterator(RecordingMap<? extends Map<K, V>, K, V> recordingMap) {
        this.recordingMap = recordingMap;
        this.iterator = recordingMap.delegate.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<K, V> next() {
        Map.Entry<K, V> entry = this.iterator.next();
        this.current = entry.getKey();
        return entry;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.recordingMap.addRemoveAction(this.current);
        this.iterator.remove();
        this.current = null;
    }
}

