/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.MapRemoveAction;
import com.blazebit.persistence.view.impl.collection.MapRemoveAllKeysAction;
import com.blazebit.persistence.view.impl.collection.RecordingKeySetIterator;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RecordingKeySet<C extends Map<K, V>, K, V>
implements Set<K>,
Serializable {
    protected final Set<K> delegate;
    protected final RecordingMap<C, K, V> recordingMap;

    public RecordingKeySet(Set<K> delegate, RecordingMap<C, K, V> recordingMap) {
        this.delegate = delegate;
        this.recordingMap = recordingMap;
    }

    @Override
    public boolean add(K e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        this.recordingMap.addAction(new MapRemoveAction(o, this.recordingMap.delegate));
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.recordingMap.addAction(new MapRemoveAllKeysAction(c, this.recordingMap.delegate));
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.recordingMap.addAction(MapRemoveAllKeysAction.retainAll(c, this.recordingMap.delegate));
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.recordingMap.addClearAction();
        this.delegate.clear();
    }

    @Override
    public Iterator<K> iterator() {
        return new RecordingKeySetIterator<K>(this.recordingMap);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }
}

