/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class SimpleCollectionAccumulator
implements ContainerAccumulator<Collection<Object>> {
    private final PluralObjectFactory<Collection<Object>> pluralObjectFactory;
    private final boolean forceUnique;
    private final Comparator<Object> comparator;

    public SimpleCollectionAccumulator(PluralObjectFactory<? extends Collection<?>> pluralObjectFactory, boolean forceUnique, Comparator<Object> comparator) {
        this.pluralObjectFactory = pluralObjectFactory;
        this.forceUnique = forceUnique;
        this.comparator = comparator;
    }

    @Override
    public Collection<Object> createContainer(boolean recording, int size) {
        return this.pluralObjectFactory.createCollection(size);
    }

    @Override
    public void add(Collection<Object> container, Object indexObject, Object value, boolean recording) {
        container.add(value);
    }

    @Override
    public void addAll(Collection<Object> container, Collection<Object> collection, boolean recording) {
        container.addAll(collection);
    }

    @Override
    public boolean requiresPostConstruct() {
        return this.forceUnique || this.comparator != null;
    }

    @Override
    public void postConstruct(Collection<Object> collection) {
        ArrayList list = (ArrayList)collection;
        if (this.forceUnique) {
            HashSet set = new HashSet(list.size());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (set.add(o)) continue;
                iter.remove();
            }
        }
        if (this.comparator != null) {
            Collections.sort(list, this.comparator);
        }
    }
}

