/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.objectbuilder.TupleId;
import com.blazebit.persistence.view.impl.objectbuilder.TupleIndexValue;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class NonIndexedTupleListTransformer
extends TupleListTransformer {
    private final int[] parentIdPositions;
    private final CollectionInstantiatorImplementor<?, ?> collectionInstantiator;
    private final boolean dirtyTracking;
    private final TypeConverter<Object, Object> elementConverter;

    public NonIndexedTupleListTransformer(int[] parentIdPositions, int startIndex, CollectionInstantiatorImplementor<?, ?> collectionInstantiator, boolean dirtyTracking, TypeConverter<Object, Object> elementConverter) {
        super(startIndex);
        this.parentIdPositions = parentIdPositions;
        this.collectionInstantiator = collectionInstantiator;
        this.dirtyTracking = dirtyTracking;
        this.elementConverter = elementConverter;
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        Object collection;
        HashMap<TupleId, TupleIndexValue> tupleIndex = new HashMap<TupleId, TupleIndexValue>(tuples.size());
        Iterator<Object[]> tupleListIter = tuples.iterator();
        while (tupleListIter.hasNext()) {
            Object[] tuple = tupleListIter.next();
            TupleId id = new TupleId(this.parentIdPositions, tuple);
            if (id.isEmpty()) continue;
            TupleIndexValue tupleIndexValue = (TupleIndexValue)tupleIndex.get(id);
            if (tupleIndexValue == null) {
                collection = this.createCollection();
                tupleIndexValue = new TupleIndexValue(collection, tuple, this.startIndex, 1);
                this.add(collection, tuple[this.startIndex]);
                tuple[this.startIndex] = collection;
                tupleIndex.put(id, tupleIndexValue);
                continue;
            }
            if (tupleIndexValue.addRestTuple(tuple, this.startIndex, 1)) {
                collection = tupleIndexValue.getTupleValue();
                this.add(collection, tuple[this.startIndex]);
                tuple[this.startIndex] = collection;
                if (!tupleIndexValue.containsRestTuple(tuple, this.startIndex, 1)) continue;
                tupleListIter.remove();
                continue;
            }
            this.add(tupleIndexValue.getTupleValue(), tuple[this.startIndex]);
            tupleListIter.remove();
        }
        if (this.collectionInstantiator.requiresPostConstruct()) {
            IdentityHashMap<Object, Boolean> handledCollections = new IdentityHashMap<Object, Boolean>(tuples.size());
            for (Object[] tuple : tuples) {
                collection = (Collection)tuple[this.startIndex];
                if (handledCollections.put(collection, Boolean.TRUE) != null) continue;
                this.collectionInstantiator.postConstruct((Collection<?>)collection);
            }
        }
        return tuples;
    }

    protected Object createCollection() {
        if (this.dirtyTracking) {
            return this.collectionInstantiator.createRecordingCollection(0);
        }
        return this.collectionInstantiator.createCollection(0);
    }

    protected void add(Object collection, Object value) {
        if (this.elementConverter != null) {
            value = this.elementConverter.convertToViewType(value);
        }
        if (value != null) {
            if (this.dirtyTracking) {
                ((RecordingCollection)collection).getDelegate().add(value);
            } else {
                ((Collection)collection).add(value);
            }
        }
    }
}

