/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.view.impl.type.BasicUserTypeRegistry;
import com.blazebit.persistence.view.impl.type.BlobBasicUserType;
import com.blazebit.persistence.view.impl.type.BlobTypeConverter;
import com.blazebit.persistence.view.impl.type.CalendarBasicUserType;
import com.blazebit.persistence.view.impl.type.ClobBasicUserType;
import com.blazebit.persistence.view.impl.type.ClobTypeConverter;
import com.blazebit.persistence.view.impl.type.DateBasicUserType;
import com.blazebit.persistence.view.impl.type.EntityBasicUserType;
import com.blazebit.persistence.view.impl.type.EnumBasicUserType;
import com.blazebit.persistence.view.impl.type.JavaSqlDateBasicUserType;
import com.blazebit.persistence.view.impl.type.NClobBasicUserType;
import com.blazebit.persistence.view.impl.type.NClobTypeConverter;
import com.blazebit.persistence.view.impl.type.TimeBasicUserType;
import com.blazebit.persistence.view.impl.type.TimestampBasicUserType;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.MutableBasicUserType;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultBasicUserTypeRegistry
implements BasicUserTypeRegistry {
    private final Map<Class<?>, BasicUserType<?>> basicUserTypes;
    private final Map<Class<?>, Map<Class<?>, TypeConverter<?, ?>>> converters;
    private final EntityMetamodel entityMetamodel;
    private final BasicUserType<Object> entityBasicUserType;

    public DefaultBasicUserTypeRegistry(BasicUserTypeRegistry original, CriteriaBuilderFactory cbf) {
        this.entityMetamodel = (EntityMetamodel)cbf.getService(EntityMetamodel.class);
        this.entityBasicUserType = new EntityBasicUserType((JpaProvider)cbf.getService(JpaProvider.class));
        HashMap basicUserTypes = new HashMap(original.getBasicUserTypes());
        HashMap converters = new HashMap(original.getTypeConverters());
        this.handleLobType(basicUserTypes, converters, Blob.class, BlobBasicUserType.INSTANCE, BlobTypeConverter.INSTANCE);
        this.handleLobType(basicUserTypes, converters, Clob.class, ClobBasicUserType.INSTANCE, ClobTypeConverter.INSTANCE);
        this.handleLobType(basicUserTypes, converters, NClob.class, NClobBasicUserType.INSTANCE, NClobTypeConverter.INSTANCE);
        for (Map.Entry entry : converters.entrySet()) {
            entry.setValue(Collections.unmodifiableMap((Map)entry.getValue()));
        }
        this.basicUserTypes = Collections.unmodifiableMap(basicUserTypes);
        this.converters = Collections.unmodifiableMap(converters);
    }

    private void handleLobType(Map<Class<?>, BasicUserType<?>> basicUserTypes, Map<Class<?>, Map<Class<?>, TypeConverter<?, ?>>> converters, Class<?> lobType, BasicUserType<?> expectedType, TypeConverter<?, ?> expectedConverter) {
        if (basicUserTypes.get(lobType) == expectedType) {
            Map<Class<?>, TypeConverter<?, ?>> converterMap = converters.get(lobType);
            if (converterMap == null || converterMap.get(lobType) != expectedConverter) {
                basicUserTypes.remove(lobType);
            }
        } else {
            Map<Class<?>, TypeConverter<?, ?>> converterMap = converters.get(lobType);
            if (converterMap != null) {
                converterMap.remove(lobType);
                if (converterMap.isEmpty()) {
                    converters.remove(lobType);
                }
            }
        }
    }

    @Override
    public <X> void registerBasicUserType(Class<X> clazz, BasicUserType<X> userType) {
        throw new IllegalArgumentException("Can't register type after building the configuration!");
    }

    @Override
    public <X, Y> void registerTypeConverter(Class<X> entityModelType, Class<Y> viewModelType, TypeConverter<X, Y> converter) {
        throw new IllegalArgumentException("Can't register type converter after building the configuration!");
    }

    @Override
    public Map<Class<?>, Map<Class<?>, TypeConverter<?, ?>>> getTypeConverters() {
        return this.converters;
    }

    @Override
    public <Y> Map<Class<?>, TypeConverter<?, Y>> getTypeConverter(Class<Y> clazz) {
        Map<Class<?>, TypeConverter<?, Y>> map = this.converters.get(clazz);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    @Override
    public Map<Class<?>, BasicUserType<?>> getBasicUserTypes() {
        return this.basicUserTypes;
    }

    @Override
    public <X> BasicUserType<X> getBasicUserType(Class<X> clazz) {
        Object userType = this.basicUserTypes.get(clazz);
        if (userType == null) {
            userType = clazz.isEnum() ? new EnumBasicUserType<X>(clazz) : (this.entityMetamodel.getEntity(clazz) != null ? this.entityBasicUserType : (Date.class == clazz ? JavaSqlDateBasicUserType.INSTANCE : (Time.class == clazz ? TimeBasicUserType.INSTANCE : (Timestamp.class == clazz ? TimestampBasicUserType.INSTANCE : (java.util.Date.class.isAssignableFrom(clazz) ? DateBasicUserType.INSTANCE : (Calendar.class.isAssignableFrom(clazz) ? CalendarBasicUserType.INSTANCE : MutableBasicUserType.INSTANCE))))));
        }
        return userType;
    }
}

