/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.cdi;

import com.blazebit.persistence.integration.view.cdi.CustomBean;
import com.blazebit.persistence.integration.view.cdi.DefaultLiteral;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViewListener;
import com.blazebit.persistence.view.EntityViewListeners;
import com.blazebit.persistence.view.EntityViews;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class EntityViewExtension
implements Extension {
    private final EntityViewConfiguration configuration = EntityViews.createDefaultConfiguration();
    private final List<RuntimeException> exceptions = new ArrayList<RuntimeException>();

    <X> void processEntityView(@Observes ProcessAnnotatedType<X> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(EntityView.class)) {
            try {
                this.configuration.addEntityView(pat.getAnnotatedType().getJavaClass());
            }
            catch (RuntimeException ex) {
                this.exceptions.add(new IllegalArgumentException("Exception occurred while reading entity view class: " + pat.getAnnotatedType().getJavaClass().getName(), ex));
            }
        } else if (pat.getAnnotatedType().isAnnotationPresent(EntityViewListener.class) || pat.getAnnotatedType().isAnnotationPresent(EntityViewListeners.class)) {
            try {
                this.configuration.addEntityViewListener(pat.getAnnotatedType().getJavaClass());
            }
            catch (RuntimeException ex) {
                this.exceptions.add(new IllegalArgumentException("Exception occurred while reading entity view class: " + pat.getAnnotatedType().getJavaClass().getName(), ex));
            }
        }
    }

    void beforeBuild(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (!this.exceptions.isEmpty()) {
            for (RuntimeException exception : this.exceptions) {
                abd.addDefinitionError((Throwable)exception);
            }
            return;
        }
        Class<EntityViewConfiguration> beanClass = EntityViewConfiguration.class;
        Class[] types = new Class[]{EntityViewConfiguration.class, Object.class};
        Annotation[] qualifiers = new Annotation[]{new DefaultLiteral()};
        Class<Dependent> scope = Dependent.class;
        CustomBean<EntityViewConfiguration> bean = new CustomBean<EntityViewConfiguration>(beanClass, types, qualifiers, scope, this.configuration);
        abd.addBean(bean);
    }
}

