/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base;

import com.blazebit.persistence.integration.hibernate.base.Database;
import com.blazebit.persistence.integration.hibernate.base.TableNameFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class SimpleDatabase
implements Database {
    private final Map<String, Table> tables;

    public SimpleDatabase(Iterator<Table> iter, Dialect dialect, TableNameFormatter formatter, Mapping mapping) {
        HashMap<String, Table> map = new HashMap<String, Table>();
        while (iter.hasNext()) {
            Table t = iter.next();
            map.put(formatter.getQualifiedTableName(dialect, t), t);
            if (t.getSubselect() != null) {
                map.put("( " + t.getSubselect() + " )", t);
            }
            Iterator columnIter = t.getColumnIterator();
            while (columnIter.hasNext()) {
                Column column = (Column)columnIter.next();
                column.getSqlType(dialect, mapping);
            }
        }
        this.tables = Collections.unmodifiableMap(map);
    }

    @Override
    public Table getTable(String name) {
        return this.tables.get(name);
    }
}

