/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate.base.function;

import com.blazebit.persistence.integration.hibernate.base.function.HibernateFunctionRenderContext;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class HibernateJpqlFunctionAdapter
implements SQLFunction {
    private final JpqlFunction function;

    public HibernateJpqlFunctionAdapter(JpqlFunction function) {
        this.function = function;
    }

    public JpqlFunction unwrap() {
        return this.function;
    }

    public boolean hasArguments() {
        return this.function.hasArguments();
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.function.hasParenthesesIfNoArguments();
    }

    public Type getReturnType(Type firstArgumentType, Mapping mapping) throws QueryException {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)mapping;
        Class argumentClass = firstArgumentType == null ? null : firstArgumentType.getReturnedClass();
        Class returnType = this.function.getReturnType(argumentClass);
        if (returnType == null) {
            return null;
        }
        if (argumentClass == returnType) {
            return firstArgumentType;
        }
        BasicType type = sfi.getTypeHelper().basic(returnType);
        if (type != null) {
            return type;
        }
        if (sfi.getEntityPersisters().containsKey(returnType.getName())) {
            return sfi.getTypeHelper().entity(returnType);
        }
        return sfi.getTypeHelper().custom(returnType);
    }

    public String render(Type firstArgumentType, List args, SessionFactoryImplementor factory) throws QueryException {
        HibernateFunctionRenderContext context = new HibernateFunctionRenderContext(args);
        this.function.render((FunctionRenderContext)context);
        return context.renderToString();
    }
}

