/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.nfs.executor;

import com.blazebit.storage.nfs.StorageAccess;
import com.blazebit.storage.nfs.executor.StorageAccessVirtualFileSystem;
import com.blazebit.storage.nfs.spi.NfsServer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ExecutorService;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.v3.MountServer;
import org.dcache.nfs.v3.NfsServerV3;
import org.dcache.nfs.v4.MDSOperationExecutor;
import org.dcache.nfs.v4.NFSServerV41;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.v4.client.Main;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.portmap.OncRpcEmbeddedPortmap;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;

public class NfsServerImpl
implements NfsServer {
    private final OncRpcSvc nfsSvc;
    private final OncRpcEmbeddedPortmap portmap;

    public NfsServerImpl(StorageAccess storageAccess, ExecutorService executorService) throws IOException {
        this(new StorageAccessVirtualFileSystem(storageAccess), executorService);
    }

    public NfsServerImpl(VirtualFileSystem vfs, ExecutorService executorService) throws IOException {
        this.nfsSvc = new OncRpcSvcBuilder().withPort(2049).withTCP().withAutoPublish().withWorkerThreadIoStrategy().withWorkerThreadExecutionService(executorService).build();
        ExportFile exportFile = new ExportFile((Reader)new StringReader("/ *(rw,all_squash,anonuid=0,anongid=0)"));
        NFSServerV41 nfs4 = new NFSServerV41.Builder().withExportTable((ExportTable)exportFile).withVfs(vfs).withOperationExecutor((OperationExecutor)new MDSOperationExecutor()).build();
        NfsServerV3 nfs3 = new NfsServerV3((ExportTable)exportFile, vfs);
        MountServer mountd = new MountServer((ExportTable)exportFile, vfs);
        this.nfsSvc.register(new OncRpcProgram(100003, 4), (RpcDispatchable)nfs4);
        this.nfsSvc.register(new OncRpcProgram(100003, 3), (RpcDispatchable)nfs3);
        this.nfsSvc.register(new OncRpcProgram(100005, 3), (RpcDispatchable)mountd);
        this.portmap = new OncRpcEmbeddedPortmap();
    }

    public static void main(String[] args) throws Exception {
        Main.main((String[])args);
    }

    public void start() throws Exception {
        this.nfsSvc.start();
    }

    public void stop() throws Exception {
        this.portmap.shutdown();
        this.nfsSvc.stop();
    }
}

