/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.nfs.executor;

import com.blazebit.storage.nfs.FileStats;
import com.blazebit.storage.nfs.StorageAccess;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.SimpleIdMap;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class StorageAccessVirtualFileSystem
implements VirtualFileSystem {
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    private final StorageAccess storageAccess;
    private final ConcurrentMap<Long, String> inodeToPath = new ConcurrentHashMap<Long, String>();
    private final ConcurrentMap<String, Long> pathToInode = new ConcurrentHashMap<String, Long>();
    private final AtomicLong fileId = new AtomicLong(1L);
    private final NfsIdMapping _idMapper = new SimpleIdMap();

    public StorageAccessVirtualFileSystem(StorageAccess storageAccess) {
        this.storageAccess = storageAccess;
        this.map(this.fileId.getAndIncrement(), "/");
    }

    private Inode toFileHandle(long inodeNumber) {
        return Inode.forFile((byte[])Longs.toByteArray((long)inodeNumber));
    }

    private long toInodeNumber(Inode inode) {
        return Longs.fromByteArray((byte[])inode.getFileId());
    }

    private String resolveInode(long inodeNumber) throws NoEntException {
        String path = (String)this.inodeToPath.get(inodeNumber);
        if (path == null) {
            throw new NoEntException("inode #" + inodeNumber);
        }
        return path;
    }

    private long resolvePath(String path) throws NoEntException {
        Long inodeNumber = (Long)this.pathToInode.get(path);
        if (inodeNumber == null) {
            throw new NoEntException("path " + path);
        }
        return inodeNumber;
    }

    private long resolveOrMapPath(String path) throws NoEntException {
        return this.pathToInode.computeIfAbsent(path, p -> {
            long inodeNumber = this.fileId.getAndIncrement();
            this.inodeToPath.putIfAbsent(inodeNumber, (String)p);
            return inodeNumber;
        });
    }

    private void map(long inodeNumber, String path) {
        if (this.inodeToPath.putIfAbsent(inodeNumber, path) != null) {
            throw new IllegalStateException();
        }
        Long otherInodeNumber = this.pathToInode.putIfAbsent(path, inodeNumber);
        if (otherInodeNumber != null) {
            if (this.inodeToPath.remove(inodeNumber) != path) {
                throw new IllegalStateException("cant map, rollback failed");
            }
            throw new IllegalStateException("path ");
        }
    }

    private void unmap(long inodeNumber, String path) {
        String removedPath = (String)this.inodeToPath.remove(inodeNumber);
        if (!path.equals(removedPath)) {
            throw new IllegalStateException();
        }
        if ((Long)this.pathToInode.remove(path) != inodeNumber) {
            throw new IllegalStateException();
        }
    }

    private void remap(long inodeNumber, String oldPath, String newPath) {
        this.unmap(inodeNumber, oldPath);
        this.map(inodeNumber, newPath);
    }

    private String resolve(String parentPath, String path) {
        if (parentPath.charAt(parentPath.length() - 1) == '/') {
            return parentPath + path;
        }
        return parentPath + "/" + path;
    }

    private String getParent(String path) {
        int idx = path.lastIndexOf(47, path.length() - 1);
        if (idx == -1) {
            return null;
        }
        return path.substring(0, idx + 1);
    }

    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        long parentInodeNumber = this.toInodeNumber(parent);
        String parentPath = this.resolveInode(parentInodeNumber);
        String newPath = this.resolve(parentPath, path);
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, newPath);
        return this.toFileHandle(newInodeNumber);
    }

    public FsStat getFsStat() throws IOException {
        long total = Long.MAX_VALUE;
        long free = Long.MAX_VALUE;
        return new FsStat(total, Long.MAX_VALUE, total - free, (long)this.pathToInode.size());
    }

    public Inode getRootInode() throws IOException {
        return this.toFileHandle(1L);
    }

    public Inode lookup(Inode parent, String path) throws IOException {
        long parentInodeNumber = this.toInodeNumber(parent);
        String parentPath = this.resolveInode(parentInodeNumber);
        String child = path.equals(".") ? parentPath : (path.equals("..") ? this.getParent(parentPath) : this.resolve(parentPath, path));
        long childInodeNumber = this.resolveOrMapPath(child);
        return this.toFileHandle(childInodeNumber);
    }

    public Inode link(Inode parent, Inode existing, String target, Subject subject) throws IOException {
        throw new NotSuppException("Not supported");
    }

    public DirectoryStream list(Inode inode, byte[] bytes, long l) throws IOException {
        Collection paths;
        long inodeNumber = this.toInodeNumber(inode);
        String path = this.resolveInode(inodeNumber);
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        if ((paths = this.storageAccess.list(path)) == null) {
            throw new NoEntException("Directory does not exists: " + path);
        }
        ArrayList<DirectoryEntry> list = new ArrayList<DirectoryEntry>(paths.size());
        int cookie = 2;
        for (String p : paths) {
            if ((long)(++cookie) <= l) continue;
            String absolutePath = path + p;
            long ino = this.resolveOrMapPath(absolutePath);
            list.add(new DirectoryEntry(p, this.toFileHandle(ino), this.statPath(absolutePath, ino), (long)cookie));
        }
        return new DirectoryStream(list);
    }

    public byte[] directoryVerifier(Inode inode) throws IOException {
        return DirectoryStream.ZERO_VERIFIER;
    }

    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        long parentInodeNumber = this.toInodeNumber(parent);
        String parentPath = this.resolveInode(parentInodeNumber);
        String newPath = this.resolve(parentPath, path);
        long newInodeNumber = this.fileId.getAndIncrement();
        this.map(newInodeNumber, newPath);
        return this.toFileHandle(newInodeNumber);
    }

    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        long currentParentInodeNumber = this.toInodeNumber(src);
        String currentParentPath = this.resolveInode(currentParentInodeNumber);
        long destParentInodeNumber = this.toInodeNumber(dest);
        String destPath = this.resolveInode(destParentInodeNumber);
        String currentPath = this.resolve(currentParentPath, oldName);
        long targetInodeNumber = this.resolvePath(currentPath);
        String newPath = this.resolve(destPath, newName);
        this.storageAccess.move(currentPath, newPath);
        this.remap(targetInodeNumber, currentPath, newPath);
        return true;
    }

    public Inode parentOf(Inode inode) throws IOException {
        long inodeNumber = this.toInodeNumber(inode);
        if (inodeNumber == 1L) {
            throw new NoEntException("no parent");
        }
        String path = this.resolveInode(inodeNumber);
        String parentPath = this.getParent(path);
        long parentInodeNumber = this.resolvePath(parentPath);
        return this.toFileHandle(parentInodeNumber);
    }

    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        long inodeNumber = this.toInodeNumber(inode);
        String path = this.resolveInode(inodeNumber);
        return this.storageAccess.read(path, data, offset, count);
    }

    public String readlink(Inode inode) throws IOException {
        throw new NotSuppException("Not supported");
    }

    public void remove(Inode parent, String path) throws IOException {
        long parentInodeNumber = this.toInodeNumber(parent);
        String parentPath = this.resolveInode(parentInodeNumber);
        String targetPath = this.resolve(parentPath, path);
        long targetInodeNumber = this.resolvePath(targetPath);
        this.storageAccess.remove(targetPath);
        this.unmap(targetInodeNumber, targetPath);
    }

    public Inode symlink(Inode parent, String linkName, String targetName, Subject subject, int mode) throws IOException {
        throw new NotSuppException("Not supported");
    }

    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        long inodeNumber = this.toInodeNumber(inode);
        String path = this.resolveInode(inodeNumber);
        int bytesWritten = this.storageAccess.write(path, data, offset, count);
        return new VirtualFileSystem.WriteResult(VirtualFileSystem.StabilityLevel.FILE_SYNC, bytesWritten);
    }

    public void commit(Inode inode, long l, int i) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Stat statPath(String p, long inodeNumber) throws IOException {
        Stat stat = new Stat();
        stat.setMode(StorageAccessVirtualFileSystem.permissionsToMode(EnumSet.allOf(PosixFilePermission.class)));
        FileStats stats = null;
        if (p.charAt(p.length() - 1) == '/' || (stats = this.storageAccess.stat(p)) != null && stats.isDirectory()) {
            stat.setMode(stat.getMode() | Stat.Type.DIRECTORY.toMode());
        } else if (stats != null && stats.isFile()) {
            stat.setMode(stat.getMode() | Stat.Type.REGULAR.toMode());
        } else {
            throw new NoEntException("File does not exist: " + p);
        }
        stat.setATime(0L);
        stat.setCTime(0L);
        stat.setMTime(0L);
        stat.setGid(0);
        stat.setUid(0);
        stat.setNlink(1);
        stat.setDev(17);
        stat.setIno((int)inodeNumber);
        stat.setRdev(17);
        if (stats == null || stats.isDirectory()) {
            stat.setSize(10L);
        } else if (stats.getSize() > 0L) {
            stat.setSize(stats.getSize());
        } else {
            stat.setSize(10L);
        }
        stat.setFileid((long)((int)inodeNumber));
        stat.setGeneration(0L);
        return stat;
    }

    public int access(Inode inode, int mode) throws IOException {
        return mode;
    }

    public Stat getattr(Inode inode) throws IOException {
        long inodeNumber = this.toInodeNumber(inode);
        String path = this.resolveInode(inodeNumber);
        return this.statPath(path, inodeNumber);
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        long inodeNumber = this.toInodeNumber(inode);
        String path = this.resolveInode(inodeNumber);
    }

    public nfsace4[] getAcl(Inode inode) throws IOException {
        return new nfsace4[0];
    }

    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        throw new UnsupportedOperationException("No ACL support");
    }

    public boolean hasIOLayout(Inode inode) throws IOException {
        return false;
    }

    public AclCheckable getAclCheckable() {
        return AclCheckable.UNDEFINED_ALL;
    }

    public NfsIdMapping getIdMapper() {
        return this._idMapper;
    }

    public byte[] getXattr(Inode inode, String attr) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String[] listXattrs(Inode inode) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeXattr(Inode inode, String attr) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static int permissionsToMode(Set<PosixFilePermission> permissions) {
        int mode = 0;
        for (PosixFilePermission p : permissions) {
            switch (p) {
                case OWNER_READ: {
                    mode |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    mode |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    mode |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    mode |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    mode |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    mode |= 8;
                    break;
                }
                case OTHERS_READ: {
                    mode |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    mode |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    mode |= 1;
                }
            }
        }
        return mode;
    }
}

