/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.weblink.core.api.WeblinkDispatcherFactoryDataAccess;
import com.blazebit.weblink.core.api.spi.ProviderMetamodel;
import com.blazebit.weblink.core.api.spi.WeblinkDispatcherFactory;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WeblinkDispatcherFactoryDataAccessImpl
extends AbstractDataAccess
implements WeblinkDispatcherFactoryDataAccess {
    private final List<WeblinkDispatcherFactory> list;
    private final Map<String, WeblinkDispatcherFactory> map;

    @Inject
    public WeblinkDispatcherFactoryDataAccessImpl(Instance<WeblinkDispatcherFactory> weblinkDispatcherFactories) {
        ArrayList<WeblinkDispatcherFactory> list = new ArrayList<WeblinkDispatcherFactory>();
        HashMap<String, WeblinkDispatcherFactory> map = new HashMap<String, WeblinkDispatcherFactory>();
        for (WeblinkDispatcherFactory factory : weblinkDispatcherFactories) {
            ProviderMetamodel metamodel = factory.getMetamodel();
            list.add(factory);
            map.put(metamodel.getKey(), factory);
        }
        this.list = Collections.unmodifiableList(list);
        this.map = Collections.unmodifiableMap(map);
    }

    public String getType(Map<String, String> configuration) {
        String type = null;
        if (configuration != null) {
            type = configuration.get("type");
        }
        return type;
    }

    public List<WeblinkDispatcherFactory> findAll() {
        return this.list;
    }

    public WeblinkDispatcherFactory findByKey(String key) {
        return this.map.get(key);
    }
}

