/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.QueryBuilder;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.weblink.core.api.WeblinkGroupDataAccess;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import com.blazebit.weblink.core.model.jpa.WeblinkGroup;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.NoResultException;

@Stateless
public class WeblinkGroupDataAccessImpl
extends AbstractDataAccess
implements WeblinkGroupDataAccess {
    public WeblinkGroup findByName(String weblinkGroupName) {
        try {
            return (WeblinkGroup)((CriteriaBuilder)this.cbf.create(this.em, WeblinkGroup.class).where("id").eq((Object)weblinkGroupName)).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> T findByName(String weblinkGroupName, EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        try {
            CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, WeblinkGroup.class).where("id").eq((Object)weblinkGroupName);
            return (T)this.evm.applySetting(setting, cb).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> T findByName(String weblinkGroupName, String prefix, Integer limit, String marker, EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        if (limit == null) {
            limit = 1000;
        } else if (limit > 1000) {
            throw new IllegalArgumentException("Limit may not exceed 1000!");
        }
        try {
            CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, WeblinkGroup.class).where("id").eq((Object)weblinkGroupName);
            if (prefix != null && !prefix.isEmpty()) {
                ((EscapeBuilder)cb.where("links.id.name").like().value((Object)(prefix.replaceAll("%", "\\%") + "%"))).escape('\\');
            }
            if (marker != null && !marker.isEmpty()) {
                cb.where("links.id.name").gt((Object)marker);
            }
            setting.addOptionalParameter("prefix", (Object)prefix);
            setting.addOptionalParameter("constraint", (Object)limit);
            setting.addOptionalParameter("marker", (Object)marker);
            cb.setMaxResults(limit.intValue());
            return (T)this.evm.applySetting(setting, cb).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> List<T> findByAccountId(long accountId, EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, WeblinkGroup.class).where("owner.id").eq((Object)accountId);
        return this.evm.applySetting(setting, cb).getResultList();
    }

    public <T> List<T> findAll(EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        CriteriaBuilder cb = this.cbf.create(this.em, WeblinkGroup.class);
        return this.evm.applySetting(setting, cb).getResultList();
    }
}

