/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.weblink.core.api.AccountNotFoundException;
import com.blazebit.weblink.core.api.WeblinkGroupNotEmptyException;
import com.blazebit.weblink.core.api.WeblinkGroupNotFoundException;
import com.blazebit.weblink.core.api.WeblinkGroupService;
import com.blazebit.weblink.core.api.WeblinkKeyStrategyFactoryDataAccess;
import com.blazebit.weblink.core.api.WeblinkMatcherFactoryDataAccess;
import com.blazebit.weblink.core.api.spi.WeblinkKeyStrategyFactory;
import com.blazebit.weblink.core.api.spi.WeblinkMatcherFactory;
import com.blazebit.weblink.core.impl.AbstractService;
import com.blazebit.weblink.core.model.jpa.Account;
import com.blazebit.weblink.core.model.jpa.WeblinkGroup;
import com.blazebit.weblink.core.model.jpa.WeblinkGroupSequence;
import java.io.Serializable;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;

@Stateless
public class WeblinkGroupServiceImpl
extends AbstractService
implements WeblinkGroupService {
    @Inject
    private WeblinkKeyStrategyFactoryDataAccess weblinkKeyStrategyFactoryDataAccess;
    @Inject
    private WeblinkMatcherFactoryDataAccess weblinkMatcherFactoryDataAccess;

    public void put(WeblinkGroup weblinkGroup) {
        WeblinkGroup currentWeblinkGroup;
        if (this.em.contains((Object)weblinkGroup)) {
            this.em.detach((Object)weblinkGroup);
        }
        if ((currentWeblinkGroup = (WeblinkGroup)this.em.find(WeblinkGroup.class, (Object)weblinkGroup.getId(), LockModeType.PESSIMISTIC_WRITE)) == null) {
            this.createObject(weblinkGroup);
            return;
        }
        if (!currentWeblinkGroup.getKeyStrategyType().equals(weblinkGroup.getKeyStrategyType()) || !currentWeblinkGroup.getKeyStrategyConfiguration().equals(weblinkGroup.getKeyStrategyConfiguration())) {
            WeblinkKeyStrategyFactory keyStrategyFactory = this.weblinkKeyStrategyFactoryDataAccess.findByKey(weblinkGroup.getKeyStrategyType());
            keyStrategyFactory.createWeblinkKeyStrategy(weblinkGroup.getKeyStrategyConfiguration());
            currentWeblinkGroup.setKeyStrategyType(weblinkGroup.getKeyStrategyType());
            currentWeblinkGroup.setKeyStrategyConfiguration(weblinkGroup.getKeyStrategyConfiguration());
        }
        if (!currentWeblinkGroup.getMatcherType().equals(weblinkGroup.getMatcherType()) || !currentWeblinkGroup.getMatcherConfiguration().equals(weblinkGroup.getMatcherConfiguration())) {
            WeblinkMatcherFactory matcherFactory = this.weblinkMatcherFactoryDataAccess.findByKey(weblinkGroup.getMatcherType());
            matcherFactory.createWeblinkMatcher(weblinkGroup.getMatcherConfiguration());
            currentWeblinkGroup.setMatcherType(weblinkGroup.getMatcherType());
            currentWeblinkGroup.setKeyStrategyConfiguration(weblinkGroup.getMatcherConfiguration());
        }
        this.em.merge((Object)currentWeblinkGroup);
        this.em.flush();
    }

    private void createObject(WeblinkGroup weblinkGroup) {
        Account owner = (Account)this.em.find(Account.class, (Object)weblinkGroup.getOwner().getId());
        if (owner == null) {
            throw new AccountNotFoundException("Account not found!");
        }
        weblinkGroup.setOwner(owner);
        WeblinkKeyStrategyFactory keyStrategyFactory = this.weblinkKeyStrategyFactoryDataAccess.findByKey(weblinkGroup.getKeyStrategyType());
        keyStrategyFactory.createWeblinkKeyStrategy(weblinkGroup.getKeyStrategyConfiguration());
        WeblinkMatcherFactory matcherFactory = this.weblinkMatcherFactoryDataAccess.findByKey(weblinkGroup.getMatcherType());
        matcherFactory.createWeblinkMatcher(weblinkGroup.getMatcherConfiguration());
        WeblinkGroupSequence sequence = new WeblinkGroupSequence();
        sequence.setId((Serializable)((Object)weblinkGroup.getId()));
        sequence.setWeblinkGroup(weblinkGroup);
        this.em.persist((Object)weblinkGroup);
        this.em.persist((Object)sequence);
        this.em.flush();
    }

    public void delete(String weblinkGroupId) {
        WeblinkGroup weblinkGroup = (WeblinkGroup)this.em.find(WeblinkGroup.class, (Object)weblinkGroupId, LockModeType.PESSIMISTIC_WRITE);
        if (weblinkGroup == null) {
            throw new WeblinkGroupNotFoundException("WeblinkGroup '" + weblinkGroupId + "' does not exist!");
        }
        try {
            this.em.remove((Object)weblinkGroup);
            this.em.flush();
        }
        catch (PersistenceException ex) {
            throw new WeblinkGroupNotEmptyException("Can not delete not empty weblink group!", (Throwable)ex);
        }
    }
}

