/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.weblink.core.api.WeblinkKeyStrategyFactoryDataAccess;
import com.blazebit.weblink.core.api.spi.ProviderMetamodel;
import com.blazebit.weblink.core.api.spi.WeblinkKeyStrategyFactory;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WeblinkKeyStrategyFactoryDataAccessImpl
extends AbstractDataAccess
implements WeblinkKeyStrategyFactoryDataAccess {
    private final List<WeblinkKeyStrategyFactory> list;
    private final Map<String, WeblinkKeyStrategyFactory> map;

    @Inject
    public WeblinkKeyStrategyFactoryDataAccessImpl(Instance<WeblinkKeyStrategyFactory> weblinkKeyStrategyFactories) {
        ArrayList<WeblinkKeyStrategyFactory> list = new ArrayList<WeblinkKeyStrategyFactory>();
        HashMap<String, WeblinkKeyStrategyFactory> map = new HashMap<String, WeblinkKeyStrategyFactory>();
        for (WeblinkKeyStrategyFactory factory : weblinkKeyStrategyFactories) {
            ProviderMetamodel metamodel = factory.getMetamodel();
            list.add(factory);
            map.put(metamodel.getKey(), factory);
        }
        this.list = Collections.unmodifiableList(list);
        this.map = Collections.unmodifiableMap(map);
    }

    public String getType(Map<String, String> configuration) {
        String type = null;
        if (configuration != null) {
            type = configuration.get("type");
        }
        return type;
    }

    public List<WeblinkKeyStrategyFactory> findAll() {
        return this.list;
    }

    public WeblinkKeyStrategyFactory findByKey(String key) {
        return this.map.get(key);
    }
}

