/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.weblink.core.api.WeblinkMatcherFactoryDataAccess;
import com.blazebit.weblink.core.api.spi.ProviderMetamodel;
import com.blazebit.weblink.core.api.spi.WeblinkMatcherFactory;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WeblinkMatcherFactoryDataAccessImpl
extends AbstractDataAccess
implements WeblinkMatcherFactoryDataAccess {
    private final List<WeblinkMatcherFactory> list;
    private final Map<String, WeblinkMatcherFactory> map;

    @Inject
    public WeblinkMatcherFactoryDataAccessImpl(Instance<WeblinkMatcherFactory> weblinkMatcherFactories) {
        ArrayList<WeblinkMatcherFactory> list = new ArrayList<WeblinkMatcherFactory>();
        HashMap<String, WeblinkMatcherFactory> map = new HashMap<String, WeblinkMatcherFactory>();
        for (WeblinkMatcherFactory factory : weblinkMatcherFactories) {
            ProviderMetamodel metamodel = factory.getMetamodel();
            list.add(factory);
            map.put(metamodel.getKey(), factory);
        }
        this.list = Collections.unmodifiableList(list);
        this.map = Collections.unmodifiableMap(map);
    }

    public String getType(Map<String, String> configuration) {
        String type = null;
        if (configuration != null) {
            type = configuration.get("type");
        }
        return type;
    }

    public List<WeblinkMatcherFactory> findAll() {
        return this.list;
    }

    public WeblinkMatcherFactory findByKey(String key) {
        return this.map.get(key);
    }
}

