/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.weblink.core.api.WeblinkSecurityConstraintFactoryDataAccess;
import com.blazebit.weblink.core.api.spi.ProviderMetamodel;
import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraintFactory;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WeblinkSecurityConstraintFactoryDataAccessImpl
extends AbstractDataAccess
implements WeblinkSecurityConstraintFactoryDataAccess {
    private final List<WeblinkSecurityConstraintFactory> list;
    private final Map<String, WeblinkSecurityConstraintFactory> map;

    @Inject
    public WeblinkSecurityConstraintFactoryDataAccessImpl(Instance<WeblinkSecurityConstraintFactory> weblinkSecurityConstraintFactories) {
        ArrayList<WeblinkSecurityConstraintFactory> list = new ArrayList<WeblinkSecurityConstraintFactory>();
        HashMap<String, WeblinkSecurityConstraintFactory> map = new HashMap<String, WeblinkSecurityConstraintFactory>();
        for (WeblinkSecurityConstraintFactory factory : weblinkSecurityConstraintFactories) {
            ProviderMetamodel metamodel = factory.getMetamodel();
            list.add(factory);
            map.put(metamodel.getKey(), factory);
        }
        this.list = Collections.unmodifiableList(list);
        this.map = Collections.unmodifiableMap(map);
    }

    public String getType(Map<String, String> configuration) {
        String type = null;
        if (configuration != null) {
            type = configuration.get("type");
        }
        return type;
    }

    public List<WeblinkSecurityConstraintFactory> findAll() {
        return this.list;
    }

    public WeblinkSecurityConstraintFactory findByKey(String key) {
        return this.map.get(key);
    }
}

