/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.QueryBuilder;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.weblink.core.api.WeblinkSecurityConstraintFactoryDataAccess;
import com.blazebit.weblink.core.api.WeblinkSecurityGroupDataAccess;
import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraint;
import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraintFactory;
import com.blazebit.weblink.core.impl.AbstractDataAccess;
import com.blazebit.weblink.core.model.jpa.Account;
import com.blazebit.weblink.core.model.jpa.WeblinkSecurityGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.NoResultException;

@Stateless
public class WeblinkSecurityGroupDataAccessImpl
extends AbstractDataAccess
implements WeblinkSecurityGroupDataAccess {
    @Inject
    private WeblinkSecurityConstraintFactoryDataAccess securityConstraintFactoryDataAccess;

    public WeblinkSecurityGroup findByOwnerAndName(Account account, String securityGroupName) {
        if (account == null) {
            return null;
        }
        try {
            CriteriaBuilder cb = (CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.em, WeblinkSecurityGroup.class).where("name").eq((Object)securityGroupName)).where("owner.id").eq((Object)account.getId());
            return (WeblinkSecurityGroup)cb.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> T findByOwnerAndName(Account account, String securityGroupName, EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        if (account == null) {
            return null;
        }
        try {
            CriteriaBuilder cb = (CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.em, WeblinkSecurityGroup.class).where("name").eq((Object)securityGroupName)).where("owner.id").eq((Object)account.getId());
            return (T)this.evm.applySetting(setting, cb).getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> List<T> findAllByAccountId(Long accountId, EntityViewSetting<T, ? extends QueryBuilder<T, ?>> setting) {
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, WeblinkSecurityGroup.class).where("owner.id").eq((Object)accountId);
        return this.evm.applySetting(setting, cb).getResultList();
    }

    public List<WeblinkSecurityConstraint> getSecurityGroupConstraints(Long securityGroupId, List<Map<String, String>> securityGroupConfiguration) {
        ArrayList<WeblinkSecurityConstraint> result = new ArrayList<WeblinkSecurityConstraint>(securityGroupConfiguration.size());
        for (Map<String, String> constraintConfig : securityGroupConfiguration) {
            WeblinkSecurityConstraintFactory factory = this.securityConstraintFactoryDataAccess.findByKey(this.securityConstraintFactoryDataAccess.getType(constraintConfig));
            result.add(factory.createConstraint(constraintConfig));
        }
        return result;
    }
}

