/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.weblink.core.api.WeblinkException;
import com.blazebit.weblink.core.api.WeblinkSecurityConstraintFactoryDataAccess;
import com.blazebit.weblink.core.api.WeblinkSecurityGroupNotFoundException;
import com.blazebit.weblink.core.api.WeblinkSecurityGroupService;
import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraintFactory;
import com.blazebit.weblink.core.impl.AbstractService;
import com.blazebit.weblink.core.model.jpa.Account;
import com.blazebit.weblink.core.model.jpa.WeblinkSecurityGroup;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;

@Stateless
public class WeblinkSecurityGroupServiceImpl
extends AbstractService
implements WeblinkSecurityGroupService {
    @Inject
    private WeblinkSecurityConstraintFactoryDataAccess securityConstraintFactoryDataAccess;

    public void put(WeblinkSecurityGroup securityGroup) {
        this.checkConstraintConfiguration(securityGroup.getConstraintConfigurations());
        if (this.em.contains((Object)securityGroup)) {
            this.em.detach((Object)securityGroup);
        }
        try {
            WeblinkSecurityGroup currentSecurityGroup = (WeblinkSecurityGroup)((CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.em, WeblinkSecurityGroup.class).where("name").eq((Object)securityGroup.getName())).where("owner.id").eq((Object)securityGroup.getOwner().getId())).getQuery().setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
            currentSecurityGroup.setName(securityGroup.getName());
            currentSecurityGroup.setTags(securityGroup.getTags());
            currentSecurityGroup.setConstraintConfigurations(securityGroup.getConstraintConfigurations());
            this.em.flush();
        }
        catch (NoResultException ex) {
            this.em.persist((Object)securityGroup);
            return;
        }
    }

    public void delete(Account account, String securityGroupName) {
        try {
            WeblinkSecurityGroup securityGroup = (WeblinkSecurityGroup)((CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.em, WeblinkSecurityGroup.class).where("name").eq((Object)securityGroupName)).where("owner.id").eq((Object)account.getId())).getQuery().setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
            this.em.remove((Object)securityGroup);
            this.em.flush();
        }
        catch (NoResultException ex) {
            throw new WeblinkSecurityGroupNotFoundException("WeblinkSecurityGroup '" + securityGroupName + "' does not exist!");
        }
        catch (PersistenceException ex) {
            throw new WeblinkException("Can not delete weblink security group!", (Throwable)ex);
        }
    }

    private void checkConstraintConfiguration(List<Map<String, String>> securityGroupConfiguration) {
        if (securityGroupConfiguration == null || securityGroupConfiguration.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty constraint configurations!");
        }
        for (Map<String, String> constraintConfig : securityGroupConfiguration) {
            WeblinkSecurityConstraintFactory factory = this.securityConstraintFactoryDataAccess.findByKey(this.securityConstraintFactoryDataAccess.getType(constraintConfig));
            if (factory == null) {
                throw new IllegalArgumentException("Unexpected constraint configuration without a type!");
            }
            factory.createConstraint(constraintConfig);
        }
    }
}

