/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.weblink.core.api.WeblinkDispatcherFactoryDataAccess;
import com.blazebit.weblink.core.api.WeblinkGroupNotFoundException;
import com.blazebit.weblink.core.api.WeblinkKeyStrategyFactoryDataAccess;
import com.blazebit.weblink.core.api.WeblinkNotFoundException;
import com.blazebit.weblink.core.api.WeblinkService;
import com.blazebit.weblink.core.api.spi.WeblinkDispatcherFactory;
import com.blazebit.weblink.core.api.spi.WeblinkKeyStrategy;
import com.blazebit.weblink.core.api.spi.WeblinkKeyStrategyFactory;
import com.blazebit.weblink.core.impl.AbstractService;
import com.blazebit.weblink.core.model.jpa.Weblink;
import com.blazebit.weblink.core.model.jpa.WeblinkGroup;
import com.blazebit.weblink.core.model.jpa.WeblinkId;
import com.blazebit.weblink.core.model.jpa.WeblinkSecurityGroup;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;

@Stateless
public class WeblinkServiceImpl
extends AbstractService
implements WeblinkService {
    @Inject
    private WeblinkKeyStrategyFactoryDataAccess weblinkKeyStrategyFactoryDataAccess;
    @Inject
    private WeblinkDispatcherFactoryDataAccess weblinkDispatcherFactoryDataAccess;

    public void put(Weblink weblink) {
        List results;
        if (this.em.contains((Object)weblink)) {
            this.em.detach((Object)weblink);
        }
        if ((results = ((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.em, Weblink.class).fetch("weblinkGroup")).where("id.weblinkGroupId").eq((Object)weblink.getId().getWeblinkGroupId())).where("id.name").eq((Object)weblink.getId().getName())).getQuery().setLockMode(LockModeType.PESSIMISTIC_WRITE).getResultList()).isEmpty()) {
            this.createObject(weblink);
            return;
        }
        Weblink currentWeblink = (Weblink)results.get(0);
        currentWeblink.setExpirationTime(weblink.getExpirationTime());
        currentWeblink.setTags(weblink.getTags());
        currentWeblink.setTargetUri(weblink.getTargetUri());
        currentWeblink.setWeblinkSecurityGroup((WeblinkSecurityGroup)this.em.getReference(WeblinkSecurityGroup.class, (Object)weblink.getWeblinkSecurityGroup().getId()));
        if (!currentWeblink.getDispatcherType().equals(weblink.getDispatcherType()) || !currentWeblink.getDispatcherConfiguration().equals(weblink.getDispatcherConfiguration())) {
            WeblinkDispatcherFactory dispatcherFactory = this.weblinkDispatcherFactoryDataAccess.findByKey(weblink.getDispatcherType());
            dispatcherFactory.createWeblinkDispatcher(weblink.getDispatcherConfiguration());
            currentWeblink.setDispatcherType(weblink.getDispatcherType());
            currentWeblink.setDispatcherConfiguration(weblink.getDispatcherConfiguration());
        }
        this.em.merge((Object)currentWeblink);
        this.em.flush();
    }

    public String create(Weblink weblink) {
        if (weblink.getId().getName() != null) {
            throw new IllegalArgumentException("The given weblink already has a name set! " + weblink.getId().getName());
        }
        if (this.em.contains((Object)weblink)) {
            this.em.detach((Object)weblink);
        }
        this.createObject(weblink);
        return weblink.getId().getName();
    }

    private void createObject(Weblink weblink) {
        List results = ((CriteriaBuilder)this.cbf.create(this.em, WeblinkGroup.class).where("id").eq((Object)weblink.getId().getWeblinkGroupId())).getQuery().setLockMode(LockModeType.PESSIMISTIC_WRITE).getResultList();
        if (results.isEmpty()) {
            throw new WeblinkGroupNotFoundException("Weblink Group not found!");
        }
        WeblinkGroup weblinkGroup = (WeblinkGroup)results.get(0);
        weblink.setWeblinkGroup(weblinkGroup);
        if (weblink.getId().getName() == null) {
            WeblinkKeyStrategyFactory keyStrategyFactory = this.weblinkKeyStrategyFactoryDataAccess.findByKey(weblinkGroup.getKeyStrategyType());
            WeblinkKeyStrategy keyStrategy = keyStrategyFactory.createWeblinkKeyStrategy(weblinkGroup.getKeyStrategyConfiguration());
            weblink.getId().setName(keyStrategy.generateKey(weblink));
        }
        WeblinkDispatcherFactory dispatcherFactory = this.weblinkDispatcherFactoryDataAccess.findByKey(weblink.getDispatcherType());
        dispatcherFactory.createWeblinkDispatcher(weblink.getDispatcherConfiguration());
        if (weblink.getWeblinkSecurityGroup() != null) {
            weblink.setWeblinkSecurityGroup((WeblinkSecurityGroup)this.em.getReference(WeblinkSecurityGroup.class, (Object)weblink.getWeblinkSecurityGroup().getId()));
        }
        this.em.persist((Object)weblink);
        this.em.flush();
    }

    public void delete(WeblinkId weblinkId) {
        try {
            this.em.remove(this.em.getReference(Weblink.class, (Object)weblinkId));
            this.em.flush();
        }
        catch (PersistenceException ex) {
            throw new WeblinkNotFoundException("Weblink [" + weblinkId + "] does not exist!");
        }
    }
}

