/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl.keygenerator;

import java.util.ArrayList;
import java.util.List;

public class StringCodeGenerator {
    private static final String DEFAULT_ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final String DEFAULT_SEPARATORS = "cfhistuCFHISTU";
    private static final int MINIMUM_ALPHABET_LENGTH = 16;
    private static final double SEP_DIV = 3.5;
    private static final int GUARD_DIV = 12;
    private final String salt;
    private final String alphabet;
    private final String seps;
    private final int minHashLength;
    private final String guards;
    private final String bufferTemplate;
    private final int bufferStart;
    private final int alphabetCopyCount;

    public StringCodeGenerator() {
        this("");
    }

    public StringCodeGenerator(String salt) {
        this(salt, 0);
    }

    public StringCodeGenerator(String salt, int minHashLength) {
        this(salt, minHashLength, DEFAULT_ALPHABET);
    }

    public StringCodeGenerator(String salt, int minHashLength, String alphabet) {
        this.salt = salt;
        this.minHashLength = minHashLength < 0 ? 0 : minHashLength;
        StringBuilder alphabetBuilder = new StringBuilder(alphabet.length());
        for (int i = 0; i < alphabet.length(); ++i) {
            if (this.indexOf(alphabetBuilder, alphabet.charAt(i)) != -1) continue;
            alphabetBuilder.append(alphabet.charAt(i));
        }
        if (alphabetBuilder.length() < 16) {
            throw new IllegalArgumentException("alphabet must contain at least 16 unique characters");
        }
        if (alphabetBuilder.indexOf(" ") != -1) {
            throw new IllegalArgumentException("alphabet cannot contains spaces");
        }
        StringBuilder sepsBuilder = new StringBuilder(DEFAULT_SEPARATORS);
        int sepsOffset = 0;
        int sepsLength = sepsBuilder.length();
        for (int i = 0; i < sepsLength; ++i) {
            int j = this.indexOf(alphabetBuilder, sepsBuilder.charAt(i - sepsOffset));
            if (j == -1) {
                sepsBuilder.deleteCharAt(i - sepsOffset);
                ++sepsOffset;
                continue;
            }
            alphabetBuilder.deleteCharAt(j);
        }
        this.consistentShuffle(sepsBuilder, this.salt);
        sepsLength = sepsBuilder.length();
        if (sepsLength == 0 || (double)(alphabetBuilder.length() / sepsLength) > 3.5) {
            int anticipatedSepsLength = (int)Math.ceil((double)alphabetBuilder.length() / 3.5);
            if (anticipatedSepsLength == 1) {
                ++anticipatedSepsLength;
            }
            if (anticipatedSepsLength > sepsLength) {
                int diff = anticipatedSepsLength - sepsLength;
                sepsBuilder.append(alphabetBuilder, 0, diff);
                alphabetBuilder.delete(0, diff);
            } else {
                sepsBuilder.delete(anticipatedSepsLength, sepsLength);
            }
        }
        this.consistentShuffle(alphabetBuilder, this.salt);
        int guardCount = (int)Math.ceil((double)alphabetBuilder.length() / 12.0);
        if (alphabetBuilder.length() < 3) {
            this.guards = sepsBuilder.substring(0, guardCount);
            this.seps = sepsBuilder.substring(guardCount);
            this.alphabet = alphabetBuilder.toString();
        } else {
            this.guards = alphabetBuilder.substring(0, guardCount);
            this.seps = sepsBuilder.toString();
            this.alphabet = alphabetBuilder.substring(guardCount);
        }
        this.bufferStart = 1 + this.salt.length();
        this.alphabetCopyCount = this.alphabet.length() - (1 + this.salt.length());
        StringBuilder buffer = new StringBuilder(this.alphabet.length());
        buffer.append(' ');
        if (this.alphabetCopyCount < 0) {
            buffer.append(this.salt, 0, this.alphabet.length() - 1);
        } else {
            buffer.append(this.salt);
            for (int i = 0; i < this.alphabetCopyCount; ++i) {
                buffer.append(' ');
            }
        }
        this.bufferTemplate = buffer.toString();
    }

    public String encode(long ... numbers) {
        for (long number : numbers) {
            if (number <= 0x20000000000000L) continue;
            throw new IllegalArgumentException("number can not be greater than 9007199254740992L");
        }
        if (numbers.length == 0) {
            return "";
        }
        return this._encode(numbers);
    }

    public long[] decode(String hash) {
        if (hash.equals("")) {
            return new long[0];
        }
        return this._decode(hash);
    }

    private String _encode(long[] numbers) {
        int numberHashInt = 0;
        for (int i = 0; i < numbers.length; ++i) {
            numberHashInt = (int)((long)numberHashInt + numbers[i] % (long)(i + 100));
        }
        StringBuilder alphabet = new StringBuilder(this.alphabet);
        StringBuilder buffer = new StringBuilder(this.bufferTemplate);
        char ret = alphabet.charAt(numberHashInt % alphabet.length());
        buffer.setCharAt(0, ret);
        StringBuilder returnSb = new StringBuilder();
        returnSb.append(ret);
        for (int i = 0; i < numbers.length; ++i) {
            long num = numbers[i];
            this.consistentShuffle(alphabet, this.createSalt(buffer, alphabet));
            StringBuilder last = this.hash(num, alphabet);
            returnSb.append((CharSequence)last);
            if (i + 1 >= numbers.length) continue;
            int sepsIndex = (int)((num %= (long)(last.charAt(0) + i)) % (long)this.seps.length());
            returnSb.append(this.seps.charAt(sepsIndex));
        }
        if (returnSb.length() < this.minHashLength) {
            int guardIndex = (numberHashInt + returnSb.charAt(0)) % this.guards.length();
            char guard = this.guards.charAt(guardIndex);
            returnSb.insert(0, guard);
            if (returnSb.length() < this.minHashLength) {
                guardIndex = (numberHashInt + returnSb.charAt(2)) % this.guards.length();
                guard = this.guards.charAt(guardIndex);
                returnSb.append(guard);
            }
        }
        int halfLen = alphabet.length() / 2;
        while (returnSb.length() < this.minHashLength) {
            this.consistentShuffle(alphabet, alphabet.toString());
            returnSb.ensureCapacity(returnSb.length() + alphabet.length());
            returnSb.insert(0, alphabet, halfLen, alphabet.length());
            returnSb.append(alphabet, 0, halfLen);
            int excess = returnSb.length() - this.minHashLength;
            if (excess <= 0) continue;
            int startPosition = excess / 2;
            returnSb.delete(startPosition + this.minHashLength, returnSb.length());
            returnSb.delete(0, startPosition);
        }
        return returnSb.toString();
    }

    private long[] _decode(String hash) {
        ArrayList<Long> ret = new ArrayList<Long>();
        List<String> hashList = this.splitByChars(hash, this.guards);
        String hashBreakdown = hashList.size() == 3 || hashList.size() == 2 ? hashList.get(1) : hashList.get(0);
        char lottery = hashBreakdown.charAt(0);
        hashBreakdown = hashBreakdown.substring(1);
        hashList = this.splitByChars(hashBreakdown, this.seps);
        StringBuilder alphabet = new StringBuilder(this.alphabet);
        StringBuilder buffer = new StringBuilder(this.bufferTemplate);
        buffer.setCharAt(0, lottery);
        for (String hashElement : hashList) {
            this.consistentShuffle(alphabet, this.createSalt(buffer, alphabet));
            ret.add(this.unhash(hashElement, alphabet));
        }
        long[] arr = new long[ret.size()];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = (Long)ret.get(k);
        }
        if (!this._encode(arr).equals(hash)) {
            arr = new long[]{};
        }
        return arr;
    }

    private String createSalt(StringBuilder buffer, StringBuilder alphabet) {
        String newSalt;
        if (this.alphabetCopyCount < 0) {
            newSalt = buffer.toString();
        } else {
            for (int j = 0; j < this.alphabetCopyCount; ++j) {
                buffer.setCharAt(this.bufferStart + j, alphabet.charAt(j));
            }
            newSalt = buffer.toString();
        }
        return newSalt;
    }

    private void consistentShuffle(StringBuilder alphabet, String salt) {
        int saltLength = salt.length();
        if (saltLength <= 0) {
            return;
        }
        char[] arr = salt.toCharArray();
        int i = alphabet.length() - 1;
        int v = 0;
        int p = 0;
        while (i > 0) {
            char asc_val = arr[v %= saltLength];
            int j = (asc_val + v + (p += asc_val)) % i;
            char tmp = alphabet.charAt(i);
            alphabet.setCharAt(i, alphabet.charAt(j));
            alphabet.setCharAt(j, tmp);
            --i;
            ++v;
        }
    }

    private StringBuilder hash(long input, StringBuilder alphabet) {
        StringBuilder hash = new StringBuilder();
        int alphabetLen = alphabet.length();
        char[] arr = new char[alphabetLen];
        alphabet.getChars(0, alphabetLen, arr, 0);
        do {
            hash.append(arr[(int)(input % (long)alphabetLen)]);
        } while ((input /= (long)alphabetLen) > 0L);
        return hash.reverse();
    }

    private Long unhash(String input, StringBuilder alphabet) {
        long number = 0L;
        char[] input_arr = input.toCharArray();
        for (int i = 0; i < input.length(); ++i) {
            long pos = this.indexOf(alphabet, input_arr[i]);
            number = (long)((double)number + (double)pos * Math.pow(alphabet.length(), input.length() - i - 1));
        }
        return number;
    }

    private int indexOf(StringBuilder sb, char c) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private List<String> splitByChars(String hash, String chars) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        int charsLength = chars.length();
        block0: for (int i = 0; i < hash.length(); ++i) {
            char c = hash.charAt(i);
            for (int j = 0; j < charsLength; ++j) {
                if (c != chars.charAt(j)) continue;
                if (sb.length() <= 0) continue block0;
                list.add(sb.toString());
                sb.setLength(0);
                continue block0;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list;
    }
}

