/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl.keygenerator;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.weblink.core.impl.AbstractService;
import com.blazebit.weblink.core.impl.keygenerator.StringCodeGenerator;
import com.blazebit.weblink.core.model.jpa.WeblinkGroupSequence;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.persistence.LockModeType;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class WeblinkGroupSequenceService
extends AbstractService {
    private final ConcurrentMap<String, StringCodeGenerator> stringCodeGenerators = new ConcurrentHashMap<String, StringCodeGenerator>();

    private StringCodeGenerator getStringCodeGenerator(String weblinkGroupId) {
        StringCodeGenerator stringCodeGenerator = (StringCodeGenerator)this.stringCodeGenerators.get(weblinkGroupId);
        if (stringCodeGenerator == null) {
            stringCodeGenerator = new StringCodeGenerator(weblinkGroupId, 5, "abcdefghijklmnopqrstuvwxyz1234567890");
            this.stringCodeGenerators.putIfAbsent(weblinkGroupId, stringCodeGenerator);
        }
        return stringCodeGenerator;
    }

    public String getNextCode(String weblinkGroupId) {
        WeblinkGroupSequence seq = (WeblinkGroupSequence)((CriteriaBuilder)this.cbf.create(this.em, WeblinkGroupSequence.class).where("id").eq((Object)weblinkGroupId)).getQuery().setLockMode(LockModeType.PESSIMISTIC_WRITE).getSingleResult();
        Long newValue = seq.getValue() + 1L;
        seq.setValue(newValue);
        this.em.flush();
        String code = this.getStringCodeGenerator(weblinkGroupId).encode(newValue);
        return code;
    }
}

