/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl.security;

import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraint;
import com.blazebit.weblink.core.model.jpa.WeblinkId;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;

public class HttpBasicSecurityConstraint
implements WeblinkSecurityConstraint {
    private static final Logger LOG = Logger.getLogger(HttpBasicSecurityConstraint.class.getName());
    private final String user;
    private final String password;
    @Inject
    private HttpServletRequest request;

    public HttpBasicSecurityConstraint(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public Response validate(WeblinkId weblinkId) {
        String auth = this.request.getHeader("Authorization");
        if (!this.isAuthorized(auth)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"BASIC realm=\"weblink\"").build();
        }
        return null;
    }

    private boolean isAuthorized(String auth) {
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase().startsWith("BASIC ")) {
            return false;
        }
        String userpassEncoded = auth.substring(6);
        String decoded = new String(DatatypeConverter.parseBase64Binary((String)userpassEncoded));
        int idx = decoded.indexOf(58);
        String user = decoded.substring(0, idx);
        String password = decoded.substring(idx + 1);
        return this.user.equals(user) && this.password.equals(password);
    }
}

