/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.core.impl.security;

import com.blazebit.weblink.core.api.spi.WeblinkSecurityConstraint;
import com.blazebit.weblink.core.model.jpa.WeblinkId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class IpRangeSecurityConstraint
implements WeblinkSecurityConstraint {
    private static final Logger LOG = Logger.getLogger(IpRangeSecurityConstraint.class.getName());
    private final long networkBaseAddr;
    private final long netmaskAddr;
    @Inject
    private HttpServletRequest request;

    public IpRangeSecurityConstraint(long networkBaseAddr, long netmaskAddr) {
        this.networkBaseAddr = networkBaseAddr;
        this.netmaskAddr = netmaskAddr;
    }

    public Response validate(WeblinkId weblinkId) {
        long clientIp;
        try {
            InetAddress clientAddress = InetAddress.getByName(this.request.getRemoteAddr());
            clientIp = IpRangeSecurityConstraint.ipToLong(clientAddress);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Could not parse remote address!", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (this.networkBaseAddr == (clientIp & this.netmaskAddr)) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public static IpRangeSecurityConstraint create(String networkAddress, String netmaskAddress) {
        long netmaskAddrLong;
        long networkAddrLong;
        InetAddress clientAddress;
        if (networkAddress == null || networkAddress.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty network address!");
        }
        if (netmaskAddress == null || netmaskAddress.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty netmask address!");
        }
        try {
            clientAddress = InetAddress.getByName(networkAddress);
            networkAddrLong = IpRangeSecurityConstraint.ipToLong(clientAddress);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid network address!", e);
        }
        try {
            clientAddress = InetAddress.getByName(netmaskAddress);
            netmaskAddrLong = IpRangeSecurityConstraint.ipToLong(clientAddress);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid netmask address!", e);
        }
        return new IpRangeSecurityConstraint(networkAddrLong & netmaskAddrLong, netmaskAddrLong);
    }

    private static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }
}

