/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.maven.scr;

import com.carrotgarden.maven.scr.MojoUtil;
import com.carrotgarden.osgi.anno.scr.make.Maker;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class CarrotOsgiScr
extends AbstractMojo {
    protected static final String LOG_PREFIX = "[DS]";
    private BuildContext buildContext;
    protected boolean enableDebugLogging;
    protected boolean enableErrorLogging;
    protected boolean enableInfoLogging;
    protected Set<String> excludedServices;
    protected String excludeFileNameRegex;
    protected boolean isIncludeEmptyDescriptor;
    protected boolean isIncludeGeneratedDescritors;
    protected boolean isProcessMainClasses;
    protected boolean isProcessTestClasses;
    private Maker maker;
    protected String outputExtensionSCR;
    protected File outputMainClasses;
    protected File outputTestClasses;
    protected MavenProject project;
    protected Set<String> properPackaging;
    protected String targetDirectorySCR;

    protected String[] contextChanged(File folder, String ... includes) {
        boolean ignoreDelta = !this.buildContext.isIncremental();
        Scanner scanner = this.buildContext.newScanner(folder, ignoreDelta);
        scanner.setIncludes(includes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    protected String[] contextDeleted(File folder, String ... includes) {
        Scanner scanner = this.buildContext.newDeleteScanner(folder);
        scanner.setIncludes(includes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    protected Iterator<File> contextIterator(final File folder, final String ... relativePathArray) {
        return new Iterator<File>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < relativePathArray.length;
            }

            @Override
            public File next() throws NoSuchElementException {
                if (this.hasNext()) {
                    return MojoUtil.absolute(new File(MojoUtil.absolute(folder), relativePathArray[this.index++]));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void contextMessageClear(File file) {
        this.buildContext.removeMessages(MojoUtil.absolute(file));
    }

    protected void contextMessageError(File file, String message, Throwable cause) {
        this.buildContext.addMessage(MojoUtil.absolute(file), 0, 0, message, 2, cause);
    }

    protected void contextRefresh(File file) {
        this.buildContext.refresh(MojoUtil.absolute(file));
    }

    protected boolean isContextFull() {
        return !this.buildContext.isIncremental();
    }

    protected boolean isContextIncremental() {
        return this.buildContext.isIncremental();
    }

    protected boolean isProperPackaging() {
        String packaging = this.project.getPackaging();
        return this.properPackaging.contains(packaging);
    }

    protected void logDebug(String text) {
        if (this.enableDebugLogging) {
            this.getLog().info((CharSequence)("[DS][DEBUG] " + text));
        }
    }

    protected void logError(String text) {
        if (this.enableErrorLogging) {
            this.getLog().info((CharSequence)("[DS][ERROR] " + text));
        }
    }

    protected void logInfo(String text) {
        if (this.enableInfoLogging) {
            this.getLog().info((CharSequence)("[DS][INFO ] " + text));
        }
    }

    protected Maker maker() {
        if (this.maker == null) {
            this.maker = new Maker(this.excludedServices);
        }
        return this.maker;
    }

    protected File outputDirectorySCR() {
        return MojoUtil.absolute(new File(MojoUtil.absolute(this.outputMainClasses), this.targetDirectorySCR));
    }

    protected File pomFile() {
        return this.project.getFile();
    }

    protected static enum ClassesSelector {
        COMPILE{

            @Override
            public File getClassesDirectory(CarrotOsgiScr mojo) {
                return MojoUtil.absolute(mojo.outputMainClasses);
            }

            @Override
            public List<String> getClasspathElements(MavenProject project) throws DependencyResolutionRequiredException {
                return project.getCompileClasspathElements();
            }
        }
        ,
        TESTING{

            @Override
            public File getClassesDirectory(CarrotOsgiScr mojo) {
                return MojoUtil.absolute(mojo.outputTestClasses);
            }

            @Override
            public List<String> getClasspathElements(MavenProject project) throws DependencyResolutionRequiredException {
                return project.getTestClasspathElements();
            }
        };


        public abstract File getClassesDirectory(CarrotOsgiScr var1);

        public abstract List<String> getClasspathElements(MavenProject var1) throws DependencyResolutionRequiredException;
    }
}

