/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.maven.scr;

import com.carrotgarden.maven.scr.CarrotOsgiScr;
import com.carrotgarden.maven.scr.MojoUtil;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoFailureException;

public class CarrotOsgiScrGenerate
extends CarrotOsgiScr {
    protected static final String NULL_XML = "null.xml";
    private int allclassesCounter;
    private int descriptorCounter;

    public void execute() throws MojoFailureException {
        try {
            this.contextMessageClear(this.pomFile());
            this.logInfo("generate");
            this.logInfo("incremental: " + this.isContextIncremental());
            if (!this.isProperPackaging()) {
                this.logInfo("skip for packaging=" + this.project.getPackaging());
                return;
            }
            File folder = this.outputDirectorySCR();
            if (!folder.exists()) {
                this.logDebug("");
                if (folder.mkdirs()) {
                    this.logDebug("folder created : " + folder);
                } else {
                    this.logError("failed to create folder : " + folder);
                }
            }
            this.logDebug("");
            this.logDebug("excludedServices");
            for (String service : this.excludedServices) {
                this.logDebug("\t service=" + service);
            }
            this.logDebug("");
            this.logDebug("properPackaging");
            for (String packaging : this.properPackaging) {
                this.logDebug("\t packaging=" + packaging);
            }
            this.descriptorCounter = 0;
            this.allclassesCounter = 0;
            long timeStart = System.nanoTime();
            if (!this.isProcessMainClasses && !this.isProcessTestClasses) {
                this.logError("you have not selected neither main nor test classes");
            }
            if (this.isProcessMainClasses) {
                this.processClassFolder(CarrotOsgiScr.ClassesSelector.COMPILE);
            }
            if (this.isProcessTestClasses) {
                this.processClassFolder(CarrotOsgiScr.ClassesSelector.TESTING);
            }
            if (this.isIncludeEmptyDescriptor) {
                this.includeEmptyDescriptor();
            }
            if (this.isIncludeGeneratedDescritors) {
                this.includeDescriptorResource();
            }
            long timeFinish = System.nanoTime();
            this.logDebug("");
            long timeDiff = timeFinish - timeStart;
            long timeRate = this.descriptorCounter == 0 ? 0L : timeDiff / (long)this.descriptorCounter;
            this.logDebug("combined classes count = " + this.allclassesCounter);
            this.logDebug("descriptor class count = " + this.descriptorCounter);
            this.logDebug("time, millis total     = " + timeDiff / 1000L / 1000L);
            this.logDebug("rate, millis per descr = " + timeRate / 1000L / 1000L);
        }
        catch (Throwable e) {
            String message = "generate failure: " + e;
            this.logError(message);
            this.contextMessageError(this.pomFile(), message, e);
            throw new MojoFailureException("bada-boom", e);
        }
    }

    protected boolean hasResource(Resource resource, List<Resource> resourceList) {
        for (Resource existing : resourceList) {
            if (!resource.getTargetPath().equals(existing.getTargetPath())) continue;
            return true;
        }
        return false;
    }

    protected void includeDescriptorResource() {
        if (this.isContextIncremental()) {
            this.logDebug("do not include descriptor resource for incremental build");
            return;
        }
        String sourcePath = this.outputDirectorySCR().getPath();
        String targetPath = this.targetDirectorySCR;
        Resource resource = new Resource();
        resource.setDirectory(sourcePath);
        resource.setTargetPath(targetPath);
        List resourceList = this.project.getResources();
        this.logDebug("");
        if (this.hasResource(resource, resourceList)) {
            this.logDebug("use existing descriptor resource = " + resource);
            return;
        }
        this.logDebug("include created descriptor resource = " + resource);
        resourceList.add(resource);
    }

    protected void includeEmptyDescriptor() throws Exception {
        if (this.isContextIncremental()) {
            this.logDebug("skip including empty descriptor for incremental build");
            return;
        }
        URL source = ((Object)((Object)this)).getClass().getResource(NULL_XML);
        File target = MojoUtil.absolute(new File(this.outputDirectorySCR(), NULL_XML));
        this.logDebug("");
        this.logDebug("including empty descriptor = " + target);
        FileUtils.copyURLToFile((URL)source, (File)target);
    }

    protected ClassLoader makeClassLoader(CarrotOsgiScr.ClassesSelector selector) throws Exception {
        List<String> pathList = selector.getClasspathElements(this.project);
        URL[] entryUrlArray = new URL[pathList.size()];
        int index = 0;
        for (String path : pathList) {
            URL entryURL = MojoUtil.absolute(path).toURI().toURL();
            this.logDebug("\t dependency = " + entryURL);
            entryUrlArray[index++] = entryURL;
        }
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader customLoader = new URLClassLoader(entryUrlArray, parentLoader);
        return customLoader;
    }

    protected String makeClassName(File classesDirectory, File classFile) {
        URI folderURI = MojoUtil.absolute(classesDirectory).toURI();
        URI fileURI = MojoUtil.absolute(classFile).toURI();
        String path = folderURI.relativize(fileURI).getPath();
        int index = path.lastIndexOf(".");
        String name = path.substring(0, index).replace("/", ".");
        return name;
    }

    protected String outputFileSCR(String name) {
        return name + "." + this.outputExtensionSCR;
    }

    protected void processClassFolder(CarrotOsgiScr.ClassesSelector selector) throws Throwable {
        File classesDirectory = selector.getClassesDirectory(this);
        this.logDebug("");
        if (!classesDirectory.exists()) {
            this.logDebug("skip for missing classes directory");
            return;
        }
        this.logDebug("input classes = " + classesDirectory);
        Iterator<File> iter = this.processIterator(classesDirectory);
        if (!iter.hasNext()) {
            this.logDebug("");
            this.logDebug("skip for no changes in classes directory");
            return;
        }
        ClassLoader loader = this.makeClassLoader(selector);
        this.logDebug("");
        this.logDebug("output directory = " + this.outputDirectorySCR());
        Pattern excludePattern = Pattern.compile(this.excludeFileNameRegex);
        while (iter.hasNext()) {
            File file = iter.next();
            if (excludePattern.matcher(file.getName()).matches()) continue;
            String name = this.makeClassName(classesDirectory, file);
            String text = this.maker().make(loader, new String[]{name});
            boolean isComponent = text != null;
            ++this.allclassesCounter;
            if (isComponent) {
                String outputFile = this.outputFileSCR(name);
                this.logDebug("\t descriptor = " + outputFile);
                this.saveDescriptor(name, text);
                ++this.descriptorCounter;
                continue;
            }
            this.logDebug("\t class is not a component: " + name);
        }
        this.logInfo("");
        if (this.descriptorCounter == 0) {
            this.logInfo("did not find any active scr components.");
        } else {
            this.logInfo("active components count = " + this.descriptorCounter);
        }
    }

    protected Iterator<File> processIterator(File folder) {
        return this.contextIterator(folder, this.contextChanged(folder, "**/*.class"));
    }

    protected void saveDescriptor(String name, String text) throws Exception {
        File file = new File(this.outputDirectorySCR(), this.outputFileSCR(name));
        FileUtils.writeStringToFile((File)MojoUtil.absolute(file), (String)text);
        this.contextRefresh(file);
    }
}

