/*
 * Decompiled with CFR 0.152.
 */
package com.carrotgarden.maven.scr;

import java.io.File;

public class MojoUtil {
    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = MojoUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void ensureFolder(File path) {
        if (path == null) {
            throw new IllegalStateException("path == null");
        }
        if (path.exists() && path.isDirectory()) {
            return;
        }
        if (path.exists() && path.isFile()) {
            path.delete();
        }
        if (path.exists() && path.isFile()) {
            throw new IllegalStateException("Can not remove file.");
        }
        path.mkdirs();
        if (path.exists() && path.isDirectory()) {
            return;
        }
        throw new IllegalStateException("Can not create folder.");
    }

    public static boolean isValidFolder(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        return file.canWrite();
    }

    private MojoUtil() {
    }

    public static File absolute(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return file.getAbsoluteFile();
    }

    public static File absolute(String file) {
        return new File(file).getAbsoluteFile();
    }
}

