/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.balancers;

import com.carrotsearch.ant.tasks.junit4.Duration;
import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.SuiteBalancer;
import com.carrotsearch.ant.tasks.junit4.SuiteBalancer$Assignment;
import com.carrotsearch.ant.tasks.junit4.balancers.ExecutionTimeBalancer$SlaveLoad;
import com.carrotsearch.ant.tasks.junit4.balancers.SuiteHint;
import com.carrotsearch.ant.tasks.junit4.listeners.ExecutionTimesReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class ExecutionTimeBalancer
extends ProjectComponent
implements SuiteBalancer {
    private List resources = new ArrayList();
    private JUnit4 owner;
    private boolean verbose;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection instanceof FileSet) {
            FileSet fileSet = (FileSet)resourceCollection;
            fileSet.setProject(this.getProject());
        }
        this.resources.add(resourceCollection);
    }

    @Override
    public List assign(Collection collection, int n, long l) {
        Object object;
        Map map = ExecutionTimesReport.mergeHints(this.resources, collection);
        ArrayList<SuiteHint> arrayList = new ArrayList<SuiteHint>();
        for (String string : collection) {
            object = (List)map.get(string);
            if (object == null) continue;
            Collections.sort(object);
            Long iterator2 = (Long)object.get(object.size() / 2);
            arrayList.add(new SuiteHint(string, iterator2));
        }
        Collections.sort(arrayList, SuiteHint.DESCENDING_BY_WEIGHT);
        PriorityQueue priorityQueue = new PriorityQueue(n, ExecutionTimeBalancer$SlaveLoad.ASCENDING_BY_ESTIMATED_FINISH);
        for (int i = 0; i < n; ++i) {
            priorityQueue.add(new ExecutionTimeBalancer$SlaveLoad(i));
        }
        ArrayList<SuiteBalancer$Assignment> arrayList2 = new ArrayList<SuiteBalancer$Assignment>();
        for (SuiteHint suiteHint : arrayList) {
            Object object2 = (ExecutionTimeBalancer$SlaveLoad)priorityQueue.remove();
            ((ExecutionTimeBalancer$SlaveLoad)object2).estimatedFinish += suiteHint.cost;
            priorityQueue.add(object2);
            this.owner.log("Expected execution time for " + suiteHint.suiteName + ": " + Duration.toHumanDuration(suiteHint.cost), 4);
            arrayList2.add(new SuiteBalancer$Assignment(suiteHint.suiteName, ((ExecutionTimeBalancer$SlaveLoad)object2).id, (int)suiteHint.cost));
        }
        object = new TreeMap<Integer, ExecutionTimeBalancer$SlaveLoad>();
        while (!priorityQueue.isEmpty()) {
            ExecutionTimeBalancer$SlaveLoad executionTimeBalancer$SlaveLoad = (ExecutionTimeBalancer$SlaveLoad)priorityQueue.remove();
            ((TreeMap)object).put(executionTimeBalancer$SlaveLoad.id, executionTimeBalancer$SlaveLoad);
        }
        for (Object object2 : ((TreeMap)object).keySet()) {
            ExecutionTimeBalancer$SlaveLoad executionTimeBalancer$SlaveLoad = (ExecutionTimeBalancer$SlaveLoad)((TreeMap)object).get(object2);
            this.owner.log(String.format(Locale.ENGLISH, "Expected execution time on JVM J%d: %8.2fs", executionTimeBalancer$SlaveLoad.id, Float.valueOf((float)executionTimeBalancer$SlaveLoad.estimatedFinish / 1000.0f)), this.verbose ? 2 : 4);
        }
        return arrayList2;
    }

    @Override
    public void setOwner(JUnit4 jUnit4) {
        this.owner = jUnit4;
    }
}

